package cn.hchub.groovy;

import cn.hchub.groovy.script.GroovyScriptFactory;
import cn.hchub.groovy.script.GroovyScriptMemoryFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Slf4j
@Configuration
@ComponentScan(basePackages = {"cn.hchub.groovy"})
public class GroovyConfig {

    @Bean
    @ConditionalOnMissingBean
    public GroovyScriptFactory groovyScriptMemoryFactory() {
        return new GroovyScriptMemoryFactory();
    }

}