package cn.hchub.groovy;

import cn.hchub.groovy.script.GroovyScriptFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scripting.ScriptSource;
import org.springframework.util.StringUtils;

public final class DatabaseScriptSource implements ScriptSource {
    /**
     * groovy数据库配置脚本
     */
    public static final String SCRIPT_SOURCE_PREFIX = "database:";
    @Autowired
    private GroovyScriptFactory groovyScriptFactory;

    private String groovyTagId;
    public DatabaseScriptSource(String groovyTagId,GroovyScriptFactory groovyScriptFactory) {
        this.groovyTagId = groovyTagId;
        this.groovyScriptFactory = groovyScriptFactory;
    }

  @Override
    public String getScriptAsString() {
        return groovyScriptFactory.getByBeanName(this.groovyTagId).getGroovyContent();
    }

    @Override
    public boolean isModified() {
        return false;
    }

    @Override
    public String suggestedClassName() {
        return StringUtils.stripFilenameExtension(this.groovyTagId);
    }

}
