/*
 * Decompiled with CFR 0.152.
 */
package cn.happyloves.ali.tools.oss;

import cn.happyloves.ali.tools.oss.properties.SmsProperties;
import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.http.MethodType;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsUtils {
    private static final Logger log = LoggerFactory.getLogger(SmsUtils.class);
    private static final String CODE = "OK";

    public static boolean sendSms(IAcsClient smsClient, SmsProperties smsProperties, SendSmsRequest sendSmsRequest) {
        CommonRequest request = new CommonRequest();
        request.setSysMethod(MethodType.POST);
        request.setSysDomain("dysmsapi.aliyuncs.com");
        request.setSysVersion("2017-05-25");
        request.setSysAction("SendSms");
        request.putQueryParameter("RegionId", smsProperties.getRegionId());
        request.putQueryParameter("PhoneNumbers", sendSmsRequest.getPhoneNumber());
        request.putQueryParameter("TemplateParam", sendSmsRequest.getTemplateParam());
        String signName = StringUtils.isNotBlank((CharSequence)sendSmsRequest.getSignName()) ? sendSmsRequest.getSignName() : smsProperties.getSingleName();
        String templateCode = StringUtils.isNotBlank((CharSequence)sendSmsRequest.getTemplateCode()) ? sendSmsRequest.getTemplateCode() : smsProperties.getTemplateCode();
        request.putQueryParameter("SignName", signName);
        request.putQueryParameter("TemplateCode", templateCode);
        try {
            CommonResponse response = smsClient.getCommonResponse(request);
            log.debug("Ali SMS Response Data: [{}]", (Object)response.getData());
            JsonObject asJsonObject = JsonParser.parseString((String)response.getData()).getAsJsonObject();
            return CODE.equals(asJsonObject.get("Code").toString());
        }
        catch (ServerException e) {
            log.error("ServerException ErrCode:[{}], ErrMsg:[{}]", (Object)e.getErrCode(), (Object)e.getErrMsg());
        }
        catch (ClientException e) {
            log.error("ClientException ErrCode:[{}], ErrMsg:[{}]", (Object)e.getErrCode(), (Object)e.getErrMsg());
        }
        return false;
    }

    public static class SendSmsRequest {
        private String phoneNumber;
        private String signName;
        private String templateCode;
        private String templateParam;

        public String getPhoneNumber() {
            return this.phoneNumber;
        }

        public String getSignName() {
            return this.signName;
        }

        public String getTemplateCode() {
            return this.templateCode;
        }

        public String getTemplateParam() {
            return this.templateParam;
        }

        public void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        public void setSignName(String signName) {
            this.signName = signName;
        }

        public void setTemplateCode(String templateCode) {
            this.templateCode = templateCode;
        }

        public void setTemplateParam(String templateParam) {
            this.templateParam = templateParam;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SendSmsRequest)) {
                return false;
            }
            SendSmsRequest other = (SendSmsRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$phoneNumber = this.getPhoneNumber();
            String other$phoneNumber = other.getPhoneNumber();
            if (this$phoneNumber == null ? other$phoneNumber != null : !this$phoneNumber.equals(other$phoneNumber)) {
                return false;
            }
            String this$signName = this.getSignName();
            String other$signName = other.getSignName();
            if (this$signName == null ? other$signName != null : !this$signName.equals(other$signName)) {
                return false;
            }
            String this$templateCode = this.getTemplateCode();
            String other$templateCode = other.getTemplateCode();
            if (this$templateCode == null ? other$templateCode != null : !this$templateCode.equals(other$templateCode)) {
                return false;
            }
            String this$templateParam = this.getTemplateParam();
            String other$templateParam = other.getTemplateParam();
            return !(this$templateParam == null ? other$templateParam != null : !this$templateParam.equals(other$templateParam));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SendSmsRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $phoneNumber = this.getPhoneNumber();
            result = result * 59 + ($phoneNumber == null ? 43 : $phoneNumber.hashCode());
            String $signName = this.getSignName();
            result = result * 59 + ($signName == null ? 43 : $signName.hashCode());
            String $templateCode = this.getTemplateCode();
            result = result * 59 + ($templateCode == null ? 43 : $templateCode.hashCode());
            String $templateParam = this.getTemplateParam();
            result = result * 59 + ($templateParam == null ? 43 : $templateParam.hashCode());
            return result;
        }

        public String toString() {
            return "SmsUtils.SendSmsRequest(phoneNumber=" + this.getPhoneNumber() + ", signName=" + this.getSignName() + ", templateCode=" + this.getTemplateCode() + ", templateParam=" + this.getTemplateParam() + ")";
        }
    }
}

