/*
 * Decompiled with CFR 0.152.
 */
package cn.happyloves.ali.tools.oss;

import cn.happyloves.ali.tools.oss.properties.OssProperties;
import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.AccessControlList;
import com.aliyun.oss.model.Bucket;
import com.aliyun.oss.model.BucketInfo;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CreateBucketRequest;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.DeleteObjectsResult;
import com.aliyun.oss.model.GeneratePresignedUrlRequest;
import com.aliyun.oss.model.ListBucketsRequest;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.aliyun.oss.model.StorageClass;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssUtils {
    private static final Logger log = LoggerFactory.getLogger(OssUtils.class);

    public static class OssUpload {
        public static List<String> listFiles(OSSClient ossClient, OssProperties ossProperties, String prefix) {
            ObjectListing objectListing = ossClient.listObjects(ossProperties.getBucketName(), prefix);
            List ossObjectSummaries = objectListing.getObjectSummaries();
            ArrayList<String> keys = new ArrayList<String>();
            for (OSSObjectSummary ossObjectSummary : ossObjectSummaries) {
                log.info("key name:{}", (Object)ossObjectSummary.getKey());
                keys.add(ossObjectSummary.getKey());
            }
            return keys;
        }

        public static List<String> listUrls(OSSClient ossClient, OssProperties ossProperties, ListObjectsRequest listObjectsRequest) {
            ObjectListing listing = ossClient.listObjects(listObjectsRequest);
            ArrayList<String> list = new ArrayList<String>();
            for (OSSObjectSummary objectSummary : listing.getObjectSummaries()) {
                list.add(ossProperties.getHTTPProtocol() + "://" + ossProperties.getBucketName() + "." + ossProperties.getEndpoint() + "/" + objectSummary.getKey());
            }
            return list;
        }

        public static List<String> deleteSpecifiedPrefixFile(OSSClient ossClient, OssProperties ossProperties, String prefix) {
            String bucketName = ossProperties.getBucketName();
            String nextMarker = null;
            ArrayList<String> keys = new ArrayList<String>();
            ObjectListing objectListing = null;
            do {
                ListObjectsRequest listObjectsRequest;
                if ((objectListing = ossClient.listObjects(listObjectsRequest = new ListObjectsRequest(bucketName).withPrefix(prefix).withMarker(nextMarker))).getObjectSummaries().size() > 0) {
                    for (OSSObjectSummary ossObjectSummary : objectListing.getObjectSummaries()) {
                        log.info("key name:{}", (Object)ossObjectSummary.getKey());
                        keys.add(ossObjectSummary.getKey());
                    }
                    ArrayList files = new ArrayList(keys.size());
                    keys.forEach(item -> files.add(ossProperties.getHome().concat("/").concat((String)item)));
                    DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(bucketName).withKeys(files);
                    ossClient.deleteObjects(deleteObjectsRequest);
                }
                nextMarker = objectListing.getNextMarker();
            } while (objectListing.isTruncated());
            return keys;
        }

        public static List<String> batchDeleteFile(OSSClient ossClient, OssProperties ossProperties, List<String> keys) {
            ArrayList files = new ArrayList(keys.size());
            keys.forEach(item -> files.add(ossProperties.getHome().concat("/").concat((String)item)));
            DeleteObjectsResult deleteObjectsResult = ossClient.deleteObjects(new DeleteObjectsRequest(ossProperties.getBucketName()).withKeys(files));
            List deletedObjects = deleteObjectsResult.getDeletedObjects();
            return deletedObjects;
        }

        public static void deleteFile(OSSClient ossClient, OssProperties ossProperties, String objectName) {
            ossClient.deleteObject(ossProperties.getBucketName(), ossProperties.getHome().concat("/").concat(objectName));
        }

        public static boolean checkFileWhetherExist(OSSClient ossClient, OssProperties ossProperties, String fileName) {
            return ossClient.doesObjectExist(ossProperties.getBucketName(), ossProperties.getHome().concat("/").concat(fileName));
        }

        public static String uploadByFilePath(OSSClient ossClient, OssProperties ossProperties, String fileName, String filePath) throws Exception {
            return OssUpload.upload(ossClient, ossProperties, fileName, new FileInputStream(filePath));
        }

        public static String uploadByUrl(OSSClient ossClient, OssProperties ossProperties, String fileName, String url) throws Exception {
            return OssUpload.upload(ossClient, ossProperties, fileName, new URL(url).openStream());
        }

        public static String upload(OSSClient ossClient, OssProperties ossProperties, String fileName, InputStream inputStream, long expireTime) throws Exception {
            String home = ossProperties.getHome();
            String cdn = ossProperties.getCdn();
            String bucketName = ossProperties.getBucketName();
            String endpoint = ossProperties.getEndpoint();
            fileName = home.concat("/").concat(fileName);
            boolean whetherIsExist = OssUpload.checkFileWhetherExist(ossClient, ossProperties, fileName);
            if (whetherIsExist) {
                throw new RuntimeException("the file is exist!!!");
            }
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setObjectAcl(CannedAccessControlList.PublicReadWrite);
            PutObjectRequest request = new PutObjectRequest(bucketName, fileName, inputStream, metadata);
            Date expire = new Date(System.currentTimeMillis() + expireTime * 1000L);
            ossClient.putObject(request);
            inputStream.close();
            String url = ossClient.generatePresignedUrl(bucketName, fileName, expire).toString();
            log.info("url:{}", (Object)url);
            if (StringUtils.isNotBlank((CharSequence)cdn)) {
                return ossClient.generatePresignedUrl(bucketName, fileName, expire).toString().replaceFirst(bucketName.concat(".").concat(endpoint), ossProperties.getCdn());
            }
            return url;
        }

        public static String upload(OSSClient ossClient, OssProperties ossProperties, String fileName, InputStream inputStream) throws Exception {
            String home = ossProperties.getHome();
            String bucketName = ossProperties.getBucketName();
            boolean whetherIsExist = OssUpload.checkFileWhetherExist(ossClient, ossProperties, fileName);
            if (whetherIsExist) {
                throw new RuntimeException("the file is exist!!!");
            }
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setObjectAcl(CannedAccessControlList.PublicReadWrite);
            PutObjectResult putObjectResult = ossClient.putObject(bucketName, home.concat("/").concat(fileName), inputStream, metadata);
            inputStream.close();
            String url = OssUpload.generateUrl(ossProperties, fileName);
            log.info("url:{}", (Object)url);
            return url;
        }

        public static String overwritingUpload(OSSClient ossClient, OssProperties ossProperties, String fileName, InputStream inputStream) throws Exception {
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setObjectAcl(CannedAccessControlList.PublicReadWrite);
            PutObjectResult putObjectResult = ossClient.putObject(ossProperties.getBucketName(), ossProperties.getHome().concat("/").concat(fileName), inputStream, metadata);
            inputStream.close();
            String url = OssUpload.generateUrl(ossProperties, fileName);
            log.info("url:{}", (Object)url);
            return url;
        }

        private static String generateUrl(OssProperties ossProperties, String fileName) {
            String cdn = ossProperties.getCdn();
            String home = ossProperties.getHome();
            if (StringUtils.isNotBlank((CharSequence)cdn)) {
                return String.format("%s://%s/%s/%s", ossProperties.getHTTPProtocol(), cdn, home, fileName);
            }
            return String.format("%s://%s.%s/%s/%s", ossProperties.getHTTPProtocol(), ossProperties.getBucketName(), ossProperties.getEndpoint(), home, fileName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void batchDownLoadOssFile(OSSClient ossClient, OssProperties ossProperties, List<String> fileNames, String zipFileName, HttpServletResponse response) {
            response.setCharacterEncoding("utf-8");
            response.setContentType("multipart/form-data");
            response.setHeader("Content-Disposition", "attachment;fileName=" + zipFileName + ".zip");
            BufferedInputStream bis = null;
            try {
                ZipOutputStream zos = new ZipOutputStream((OutputStream)response.getOutputStream());
                int sortNum = 0;
                for (String fileName : fileNames) {
                    Date expiration = new Date(System.currentTimeMillis() + 3600000L);
                    GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(ossProperties.getBucketName(), fileName, HttpMethod.GET);
                    request.setExpiration(expiration);
                    URL signedUrl = ossClient.generatePresignedUrl(request);
                    OSSObject ossObject = ossClient.getObject(signedUrl, new HashMap());
                    if (ossObject != null) {
                        int read;
                        InputStream inputStream = ossObject.getObjectContent();
                        byte[] buffs = new byte[10240];
                        String zipFile = sortNum + "_" + fileName.substring(fileName.lastIndexOf("/") + 1);
                        ZipEntry zipEntry = new ZipEntry(zipFile);
                        zos.putNextEntry(zipEntry);
                        bis = new BufferedInputStream(inputStream, 10240);
                        while ((read = bis.read(buffs, 0, 10240)) != -1) {
                            zos.write(buffs, 0, read);
                        }
                        ossObject.close();
                    }
                    ++sortNum;
                }
                zos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (null != bis) {
                        bis.close();
                    }
                    response.getOutputStream().flush();
                    response.getOutputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class OssBucket {
        private static final String SUCCESS = "success";
        private static final String FAILED = "failed";

        public static String createBucket(OSSClient ossClient, String bucketName) {
            CreateBucketRequest createBucketRequest = new CreateBucketRequest(bucketName);
            createBucketRequest.setCannedACL(CannedAccessControlList.PublicRead);
            createBucketRequest.setStorageClass(StorageClass.IA);
            try {
                ossClient.createBucket(createBucketRequest);
                return SUCCESS;
            }
            catch (OSSException e) {
                log.error("error:{}", (Object)e.getMessage());
                return FAILED;
            }
        }

        public static List<Bucket> listBucket(OSSClient ossClient, String bucketPrefix) {
            ListBucketsRequest listBucketsRequest = new ListBucketsRequest();
            if (StringUtils.isNotBlank((CharSequence)bucketPrefix)) {
                listBucketsRequest.setPrefix(bucketPrefix);
            }
            try {
                return ossClient.listBuckets(listBucketsRequest).getBucketList();
            }
            catch (OSSException e) {
                log.error("error:{}", (Object)e.getMessage());
                return new ArrayList<Bucket>();
            }
        }

        public static Map<String, Object> getBucketInfo(OSSClient ossClient, String bucketName) {
            boolean exists = ossClient.doesBucketExist(bucketName);
            if (!exists) {
                return new HashMap<String, Object>(1);
            }
            HashMap<String, Object> result = new HashMap<String, Object>(4);
            BucketInfo info = ossClient.getBucketInfo(bucketName);
            result.put("location", info.getBucket().getLocation());
            result.put("createTime", new SimpleDateFormat("yyyy-MM-dd HH:ss").format(info.getBucket().getCreationDate()));
            result.put("owner", info.getBucket().getOwner());
            AccessControlList acl = ossClient.getBucketAcl(bucketName);
            result.put("authority", acl.toString());
            return result;
        }

        public static boolean deleteBucket(OSSClient ossClient, String bucketName) {
            boolean exists = ossClient.doesBucketExist(bucketName);
            if (!exists) {
                return false;
            }
            ossClient.deleteBucket(bucketName);
            return true;
        }
    }
}

