/*
 * Decompiled with CFR 0.152.
 */
package cn.happyloves.ali.tools.oss.autoconfigure;

import cn.happyloves.ali.tools.oss.condiotion.OssCondition;
import cn.happyloves.ali.tools.oss.properties.OssProperties;
import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.DefaultCredentialProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={OssProperties.class})
@Conditional(value={OssCondition.class})
@ConditionalOnProperty(prefix="ali-tools.oss", value={"true"}, matchIfMissing=true)
public class OssAutoConfiguration {
    @Autowired
    private OssProperties ossProperties;

    @Bean
    public OSSClient ossClient() {
        ClientConfiguration config = this.ossProperties.getClientConfig();
        String endpoint = this.ossProperties.getEndpoint();
        String accessKeyId = this.ossProperties.getAccessKeyId();
        String accessKeySecret = this.ossProperties.getAccessKeySecret();
        DefaultCredentialProvider defaultCredentialProvider = new DefaultCredentialProvider(accessKeyId, accessKeySecret);
        if (config == null) {
            config = new ClientConfiguration();
        }
        return new OSSClient(endpoint, (CredentialsProvider)defaultCredentialProvider, config);
    }
}

