/*
 * Decompiled with CFR 0.152.
 */
package cn.happyloves.ali.tools.oss;

import cn.happyloves.ali.tools.oss.properties.OssProperties;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.AccessControlList;
import com.aliyun.oss.model.Bucket;
import com.aliyun.oss.model.BucketInfo;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CreateBucketRequest;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.DeleteObjectsResult;
import com.aliyun.oss.model.ListBucketsRequest;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.aliyun.oss.model.StorageClass;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssUtils {
    private static final Logger log = LoggerFactory.getLogger(OssUtils.class);

    public static class OssUpload {
        public static List<String> listFiles(OSSClient ossClient, OssProperties aliyunOssProperties, String prefix) {
            ObjectListing objectListing = ossClient.listObjects(aliyunOssProperties.getBucketName(), prefix);
            List ossObjectSummaries = objectListing.getObjectSummaries();
            ArrayList<String> keys = new ArrayList<String>();
            for (OSSObjectSummary ossObjectSummary : ossObjectSummaries) {
                log.info("key name:{}", (Object)ossObjectSummary.getKey());
                keys.add(ossObjectSummary.getKey());
            }
            return keys;
        }

        public static List<String> deleteSpecifiedPrefixFile(OSSClient ossClient, OssProperties aliyunOssProperties, String prefix) {
            String bucketName = aliyunOssProperties.getBucketName();
            String nextMarker = null;
            ArrayList<String> keys = new ArrayList<String>();
            ObjectListing objectListing = null;
            do {
                ListObjectsRequest listObjectsRequest;
                if ((objectListing = ossClient.listObjects(listObjectsRequest = new ListObjectsRequest(bucketName).withPrefix(prefix).withMarker(nextMarker))).getObjectSummaries().size() > 0) {
                    for (OSSObjectSummary ossObjectSummary : objectListing.getObjectSummaries()) {
                        log.info("key name:{}", (Object)ossObjectSummary.getKey());
                        keys.add(ossObjectSummary.getKey());
                    }
                    ArrayList files = new ArrayList(keys.size());
                    keys.forEach(item -> files.add(aliyunOssProperties.getHome().concat("/").concat((String)item)));
                    DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(bucketName).withKeys(files);
                    ossClient.deleteObjects(deleteObjectsRequest);
                }
                nextMarker = objectListing.getNextMarker();
            } while (objectListing.isTruncated());
            return keys;
        }

        public static List<String> batchDeleteFile(OSSClient ossClient, OssProperties aliyunOssProperties, List<String> keys) {
            ArrayList files = new ArrayList(keys.size());
            keys.forEach(item -> files.add(aliyunOssProperties.getHome().concat("/").concat((String)item)));
            DeleteObjectsResult deleteObjectsResult = ossClient.deleteObjects(new DeleteObjectsRequest(aliyunOssProperties.getBucketName()).withKeys(files));
            List deletedObjects = deleteObjectsResult.getDeletedObjects();
            return deletedObjects;
        }

        public static void deleteFile(OSSClient ossClient, OssProperties aliyunOssProperties, String objectName) {
            ossClient.deleteObject(aliyunOssProperties.getBucketName(), aliyunOssProperties.getHome().concat("/").concat(objectName));
        }

        public static boolean checkFileWhetherExist(OSSClient ossClient, OssProperties aliyunOssProperties, String fileName) {
            boolean whetherExist = ossClient.doesObjectExist(aliyunOssProperties.getBucketName(), aliyunOssProperties.getHome().concat("/").concat(fileName));
            return whetherExist;
        }

        public static String uploadByFilePath(OSSClient ossClient, OssProperties aliyunOssProperties, String fileName, String filePath) throws Exception {
            return OssUpload.upload(ossClient, aliyunOssProperties, fileName, new FileInputStream(filePath));
        }

        public static String uploadByUrl(OSSClient ossClient, OssProperties aliyunOssProperties, String fileName, String url) throws Exception {
            return OssUpload.upload(ossClient, aliyunOssProperties, fileName, new URL(url).openStream());
        }

        public static String upload(OSSClient ossClient, OssProperties aliyunOssProperties, String fileName, InputStream inputStream, long expireTime) throws Exception {
            String home = aliyunOssProperties.getHome();
            String cdn = aliyunOssProperties.getCdn();
            String bucketName = aliyunOssProperties.getBucketName();
            String endpoint = aliyunOssProperties.getEndpoint();
            fileName = home.concat("/").concat(fileName);
            boolean whetherIsExist = OssUpload.checkFileWhetherExist(ossClient, aliyunOssProperties, fileName);
            if (whetherIsExist) {
                throw new RuntimeException("the file is exist!!!");
            }
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setObjectAcl(CannedAccessControlList.PublicReadWrite);
            PutObjectRequest request = new PutObjectRequest(bucketName, fileName, inputStream, metadata);
            Date expire = new Date(System.currentTimeMillis() + expireTime * 1000L);
            ossClient.putObject(request);
            inputStream.close();
            String url = ossClient.generatePresignedUrl(bucketName, fileName, expire).toString();
            log.info("url:{}", (Object)url);
            if (StringUtils.isNotBlank((CharSequence)cdn)) {
                return ossClient.generatePresignedUrl(bucketName, fileName, expire).toString().replaceFirst(bucketName.concat(".").concat(endpoint), aliyunOssProperties.getCdn());
            }
            return url;
        }

        public static String upload(OSSClient ossClient, OssProperties aliyunOssProperties, String fileName, InputStream inputStream) throws Exception {
            String home = aliyunOssProperties.getHome();
            String bucketName = aliyunOssProperties.getBucketName();
            boolean whetherIsExist = OssUpload.checkFileWhetherExist(ossClient, aliyunOssProperties, fileName);
            if (whetherIsExist) {
                throw new RuntimeException("the file is exist!!!");
            }
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setObjectAcl(CannedAccessControlList.PublicReadWrite);
            PutObjectResult putObjectResult = ossClient.putObject(bucketName, home.concat("/").concat(fileName), inputStream, metadata);
            inputStream.close();
            String url = OssUpload.generateUrl(aliyunOssProperties, fileName);
            log.info("url:{}", (Object)url);
            return url;
        }

        private static String generateUrl(OssProperties aliyunOssProperties, String fileName) {
            String cdn = aliyunOssProperties.getCdn();
            String home = aliyunOssProperties.getHome();
            if (StringUtils.isNotBlank((CharSequence)cdn)) {
                return String.format("https://%s/%s/%s", cdn, home, fileName);
            }
            return String.format("https://%s.%s/%s/%s", aliyunOssProperties.getBucketName(), aliyunOssProperties.getEndpoint(), home, fileName);
        }
    }

    public static class OssBucket {
        private static final String SUCCESS = "success";
        private static final String FAILED = "failed";

        public static String createBucket(OSSClient ossClient, String bucketName) {
            CreateBucketRequest createBucketRequest = new CreateBucketRequest(bucketName);
            createBucketRequest.setCannedACL(CannedAccessControlList.PublicRead);
            createBucketRequest.setStorageClass(StorageClass.IA);
            try {
                ossClient.createBucket(createBucketRequest);
                return SUCCESS;
            }
            catch (OSSException e) {
                log.error("error:{}", (Object)e.getMessage());
                return FAILED;
            }
        }

        public static List<Bucket> listBucket(OSSClient ossClient, String bucketPrefix) {
            ListBucketsRequest listBucketsRequest = new ListBucketsRequest();
            if (StringUtils.isNotBlank((CharSequence)bucketPrefix)) {
                listBucketsRequest.setPrefix(bucketPrefix);
            }
            try {
                return ossClient.listBuckets(listBucketsRequest).getBucketList();
            }
            catch (OSSException e) {
                log.error("error:{}", (Object)e.getMessage());
                return new ArrayList<Bucket>();
            }
        }

        public static Map getBucketInfo(OSSClient ossClient, String bucketName) {
            boolean exists = ossClient.doesBucketExist(bucketName);
            if (!exists) {
                return new HashMap(1);
            }
            HashMap<String, String> result = new HashMap<String, String>(4);
            BucketInfo info = ossClient.getBucketInfo(bucketName);
            result.put("location", info.getBucket().getLocation());
            result.put("createTime", new SimpleDateFormat("yyyy-MM-dd HH:ss").format(info.getBucket().getCreationDate()));
            result.put("owner", (String)info.getBucket().getOwner());
            AccessControlList acl = ossClient.getBucketAcl(bucketName);
            result.put("authority", acl.toString());
            return result;
        }

        public static boolean deleteBucket(OSSClient ossClient, String bucketName) {
            boolean exists = ossClient.doesBucketExist(bucketName);
            if (!exists) {
                return false;
            }
            ossClient.deleteBucket(bucketName);
            return true;
        }
    }
}

