/*
 * Decompiled with CFR 0.152.
 */
package cn.happyloves.ali.tools.oss;

import com.aliyun.oss.OSS;
import com.aliyun.oss.common.utils.IOUtils;
import com.aliyun.oss.model.OSSObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;
import org.springframework.stereotype.Service;
import org.springframework.util.StreamUtils;

@Service
public class OssDemoService {
    @Autowired
    private OSS ossClient;
    @Value(value="classpath:/oss-test.json")
    private Resource localFile;
    @Value(value="oss://spring-cloud-alibaba-test/oss-test.json")
    private Resource remoteFile;

    public String readRemoteFileViaResource() throws IOException {
        return IOUtils.readStreamAsString((InputStream)this.remoteFile.getInputStream(), (String)"UTF-8");
    }

    public String readRemoteFileViaClient() throws IOException {
        OSSObject ossObject = this.ossClient.getObject("spring-cloud-alibaba-test", "oss-test.json");
        return IOUtils.readStreamAsString((InputStream)ossObject.getObjectContent(), (String)"UTF-8");
    }

    public void uploadWithClient() {
        this.ossClient.putObject("spring-cloud-alibaba-test", "oss-test.json", this.getClass().getClassLoader().getResourceAsStream("oss-test.json"));
    }

    public void uploadWithOutputStream() throws IOException {
        try (OutputStream out = ((WritableResource)this.remoteFile).getOutputStream();
             InputStream in = this.localFile.getInputStream();){
            StreamUtils.copy((InputStream)in, (OutputStream)out);
        }
    }
}

