/*
 * Decompiled with CFR 0.152.
 */
package cn.hangsman.operationlog.test.spel;

import cn.hangsman.operationlog.expression.SpelFunction;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JsonSpelFunction
implements SpelFunction {
    private static final Logger log = LoggerFactory.getLogger(JsonSpelFunction.class);
    @Autowired
    ObjectMapper objectMapper;

    public Object apply(Object value) {
        try {
            return this.objectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            log.error("serialization failed", (Throwable)e);
            return "";
        }
    }

    public String functionName() {
        return "json";
    }
}

