package cn.hangsman.operatlelog.spring.boot.autoconfigure;

import cn.hangsman.operatelog.function.LogParseFunction;
import cn.hangsman.operatelog.function.LogParseFunctionFactory;
import cn.hangsman.operatelog.interceptor.OperateLogInterceptor;
import cn.hangsman.operatelog.service.DefaultLogRecordService;
import cn.hangsman.operatelog.service.DefaultOperatorService;
import cn.hangsman.operatelog.service.LogRecordService;
import cn.hangsman.operatelog.service.OperatorService;
import cn.hangsman.operatlelog.spring.boot.EnableOperateLogRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;

import java.util.List;
import java.util.Map;

/**
 * Created by 2022/1/9 14:33
 *
 * @author hangsman
 * @since 1.0
 */
@Configuration(proxyBeanMethods = false)
public class OperateLogProxyAutoConfiguration implements ImportAware {

    private AnnotationAttributes enableOperateLogRecord;

    @Bean
    @ConditionalOnMissingBean(LogParseFunctionFactory.class)
    public LogParseFunctionFactory parseFunctionFactory(@Autowired(required = false) List<LogParseFunction> parseFunctions) {
        return new LogParseFunctionFactory(parseFunctions);
    }

    @Bean
    @ConditionalOnMissingBean(LogRecordService.class)
    public LogRecordService logRecordService() {
        return new DefaultLogRecordService();
    }

    @Bean
    @ConditionalOnMissingBean(OperatorService.class)
    public OperatorService operatorService() {
        return new DefaultOperatorService();
    }

    @Bean
    public OperateLogInterceptor logRecordInterceptor(LogParseFunctionFactory parseFunctionFactory,
                                                      LogRecordService logRecordService,
                                                      OperatorService operatorService) {
        OperateLogInterceptor interceptor = new OperateLogInterceptor(enableOperateLogRecord.getString("tenant"));
        interceptor.setParseFunctionFactory(parseFunctionFactory);
        interceptor.setOperatorService(operatorService);
        interceptor.setLogRecordService(logRecordService);
        return interceptor;
    }

    @Override
    public void setImportMetadata(AnnotationMetadata importMetadata) {
        String annotationName = cn.hangsman.operatlelog.spring.boot.EnableOperateLogRecord.class.getName();
        Map<String, Object> annotationAttributes = importMetadata.getAnnotationAttributes(annotationName);
        this.enableOperateLogRecord = AnnotationAttributes.fromMap(annotationAttributes);
    }
}
