package cn.handyplus.lib.attribute;

import cn.handyplus.lib.InitApi;
import cn.handyplus.lib.core.NumberUtil;
import cn.handyplus.lib.util.BaseUtil;
import io.lumine.mythic.lib.api.player.MMOPlayerData;
import io.lumine.mythic.lib.api.stat.StatInstance;
import io.lumine.mythic.lib.api.stat.StatMap;
import io.lumine.mythic.lib.api.stat.modifier.StatModifier;
import io.lumine.mythic.lib.player.modifier.ModifierType;
import org.bukkit.entity.Player;

import java.util.List;

/**
 * MythicLib支持
 *
 * @author handy
 * @since 1.0.3
 */
public class MythicLibUtil {

    private MythicLibUtil() {
    }

    /**
     * 给玩家添加属性
     *
     * @param player        玩家
     * @param attributeList 属性列表
     */
    protected static void addAttribute(Player player, List<String> attributeList) {
        MMOPlayerData playerData = MMOPlayerData.get(player.getUniqueId());
        for (String attribute : attributeList) {
            String[] split = attribute.split(":");
            String attributeName = split[0].trim();
            String attributeValue = split[1].trim();
            StatModifier experienceModifier = new StatModifier(InitApi.PLUGIN.getName(),
                    // 移除颜色代码 -转换_ 转大写
                    BaseUtil.stripColor(attributeName).toUpperCase().replace("-", "_"),
                    NumberUtil.isNumericToDouble(attributeValue, 0.00),
                    ModifierType.FLAT);
            experienceModifier.register(playerData);
        }
    }

    /**
     * 移除玩家属性
     *
     * @param player 玩家
     */
    protected static void removeAttribute(Player player) {
        MMOPlayerData playerData = MMOPlayerData.get(player.getUniqueId());
        StatMap statMap = playerData.getStatMap();
        for (StatInstance instance : statMap.getInstances()) {
            instance.removeIf(i -> i.equals(InitApi.PLUGIN.getName()));
        }
    }

}