package cn.handyplus.lib.attribute;

import cn.handyplus.lib.InitApi;
import com.skillw.attsystem.api.AttrAPI;
import org.bukkit.entity.Player;

import java.util.List;

/**
 * AttributeSystem 兼容
 *
 * @author handy
 */
public class AttributeSystemUtil {

    private AttributeSystemUtil() {
    }

    /**
     * 给玩家添加属性
     *
     * @param player        玩家
     * @param attributeList 属性
     */
    protected static void addAttribute(Player player, List<String> attributeList) {
        AttrAPI.addAttribute(player.getUniqueId(), InitApi.PLUGIN.getName(), attributeList, false);
    }

    /**
     * 移除玩家属性
     *
     * @param player 玩家
     */
    protected static void removeAttribute(Player player) {
        AttrAPI.removeAttribute(player.getUniqueId(), InitApi.PLUGIN.getName());
    }

}