package cn.handyplus.lib.attribute;

import cn.handyplus.lib.InitApi;
import org.bukkit.entity.Player;
import org.serverct.ersha.jd.AttributeAPI;

import java.util.List;

/**
 * AttributePlus 兼容
 *
 * @author handy
 */
public class AttributePlusV2Util {

    private AttributePlusV2Util() {
    }

    /**
     * 给玩家添加属性
     *
     * @param player        玩家
     * @param attributeList 属性
     */
    protected static void addAttribute(Player player, List<String> attributeList) {
        AttributeAPI.addAttribute(player, InitApi.PLUGIN.getName(), attributeList, false);
    }

    /**
     * 移除玩家属性
     *
     * @param player 玩家
     */
    protected static void removeAttribute(Player player) {
        AttributeAPI.deleteAttribute(player, InitApi.PLUGIN.getName());
    }

}