package cn.handyplus.lib.attribute;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 属性类型
 *
 * @author handy
 */
@Getter
@AllArgsConstructor
public enum AttributeEnum {
    /**
     * ALL - 清理属性用
     */
    ALL("all"),

    /**
     * AttributePlus
     */
    ATTRIBUTE_PLUS("attribute_plus"),

    /**
     * AttributeSystem
     */
    ATTRIBUTE_SYSTEM("AttributeSystem"),

    /**
     * SxAttribute
     */
    SX_ATTRIBUTE("sx_attribute"),

    /**
     * MMOItems
     */
    MMO_ITEMS("MMOItems"),

    /**
     * 药水
     */
    POTION_EFFECT("potionEffect"),

    /**
     * MythicLib
     */
    MYTHIC_LIB("MythicLib");

    /**
     * 类型
     */
    private final String type;

    /**
     * 获取buff类型
     *
     * @param buffType buff
     * @return AttributeEnum
     */
    public static AttributeEnum getEnum(String buffType) {
        for (AttributeEnum attributeEnum : AttributeEnum.values()) {
            if (attributeEnum.getType().equalsIgnoreCase(buffType)) {
                return attributeEnum;
            }
        }
        return null;
    }

}