package cn.handyplus.lib.attribute;

/**
 * 属性类型
 *
 * @author handy
 */
public enum AttributeEnum {
    /**
     * ALL - 清理属性用
     */
    ALL("all"),

    /**
     * AttributePlus
     */
    ATTRIBUTE_PLUS("attribute_plus"),

    /**
     * AttributeSystem
     */
    ATTRIBUTE_SYSTEM("AttributeSystem"),

    /**
     * SxAttribute
     */
    SX_ATTRIBUTE("sx_attribute"),

    /**
     * MMOItems
     */
    MMO_ITEMS("MMOItems"),

    /**
     * 药水
     */
    POTION_EFFECT("MMOItems");

    private final String type;

    /**
     * 构造
     *
     * @param type 类型
     */
    AttributeEnum(String type) {
        this.type = type;
    }

    /**
     * 获取buff类型
     *
     * @param buffType buff
     * @return AttributeEnum
     */
    public static AttributeEnum getEnum(String buffType) {
        for (AttributeEnum attributeEnum : AttributeEnum.values()) {
            if (attributeEnum.getType().equalsIgnoreCase(buffType)) {
                return attributeEnum;
            }
        }
        return null;
    }

    /**
     * 获取类型
     *
     * @return 类型
     */
    public String getType() {
        return type;
    }

}
