/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.lib.attribute;

import cn.handyplus.lib.attribute.PotionEffectParam;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PotionEffectUtil {
    private static final PotionEffectUtil INSTANCE = new PotionEffectUtil();

    private PotionEffectUtil() {
    }

    public static PotionEffectUtil getInstance() {
        return INSTANCE;
    }

    protected void addAttribute(Player player, List<String> attributeList) {
        ArrayList<PotionEffectParam> peList = new ArrayList<PotionEffectParam>();
        for (String attribute : attributeList) {
            PotionEffectParam potionEffectParam = (PotionEffectParam)new Gson().fromJson(attribute, PotionEffectParam.class);
            peList.add(potionEffectParam);
        }
        ArrayList<PotionEffect> potionEffects = new ArrayList<PotionEffect>();
        for (PotionEffectParam potionEffectParam : peList) {
            PotionEffectType potionEffectType = PotionEffectType.getByName((String)potionEffectParam.getPotionName());
            if (potionEffectType == null) continue;
            int potionLevel = potionEffectParam.getPotionLevel() - 1;
            if (potionLevel < 0) {
                potionLevel = 0;
            }
            PotionEffect potionEffect = this.isOldVersion() ? new PotionEffect(potionEffectType, 1728000, potionLevel, false) : new PotionEffect(potionEffectType, 1728000, potionLevel, false, potionEffectParam.getPotionHide() == false);
            potionEffects.add(potionEffect);
        }
        if (!potionEffects.isEmpty()) {
            player.addPotionEffects(potionEffects);
        }
    }

    protected void removeAttribute(Player player) {
        Collection activePotionEffects = player.getActivePotionEffects();
        if (activePotionEffects.isEmpty()) {
            return;
        }
        for (PotionEffect potionEffect : activePotionEffects) {
            if (potionEffect.getDuration() <= 9600) continue;
            player.removePotionEffect(potionEffect.getType());
        }
    }

    private boolean isOldVersion() {
        String version = Bukkit.getVersion();
        version = version.substring(version.indexOf(":") + 2);
        return version.contains("1.7");
    }
}

