/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.util;

import cn.hamm.airpower.config.Configs;
import cn.hamm.airpower.enums.ServiceError;
import cn.hamm.airpower.util.Utils;
import org.springframework.stereotype.Component;

@Component
public class SecurityUtil {
    public final long getIdFromAccessToken(String accessToken) {
        ServiceError.UNAUTHORIZED.whenNull(accessToken);
        Object userId = Utils.getTokenUtil().verify(accessToken, Configs.getServiceConfig().getAccessTokenSecret()).getPayload("id");
        ServiceError.UNAUTHORIZED.whenNull(userId);
        return Long.parseLong(userId.toString());
    }

    public final String createAccessToken(Long id) {
        return Utils.getTokenUtil().addPayload("id", id).setExpireMillisecond(Configs.getServiceConfig().getAuthorizeExpireSecond() * 1000L).create(Configs.getServiceConfig().getAccessTokenSecret());
    }
}

