/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.util;

import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class RandomUtil {
    private static final String BASE_CHAR = "abcdefghijklmnopqrstuvwxyz";
    private static final String BASE_NUMBER = "0123456789";
    private static final String BASE_CHAR_NUMBER_LOWER = "abcdefghijklmnopqrstuvwxyz0123456789";
    private static final String BASE_CHAR_NUMBER = "abcdefghijklmnopqrstuvwxyz".toUpperCase() + "abcdefghijklmnopqrstuvwxyz0123456789";

    public final byte @NotNull [] randomBytes(int length) {
        byte[] bytes = new byte[length];
        IntStream.range(0, length).forEach(i -> {
            bytes[i] = (byte)(Math.random() * 256.0 - 128.0);
        });
        return bytes;
    }

    public final byte @NotNull [] randomBytes() {
        return this.randomBytes(32);
    }

    @NotNull
    public final String randomString() {
        return this.randomString(32);
    }

    @NotNull
    public final String randomString(int length) {
        return this.randomString(BASE_CHAR_NUMBER, length);
    }

    @NotNull
    public final String randomNumbers(int length) {
        return this.randomString(BASE_NUMBER, length);
    }

    @NotNull
    public final String randomString(String baseString, int length) {
        if (!StringUtils.hasText((String)baseString)) {
            return "";
        }
        length = Math.max(length, 1);
        int baseLength = baseString.length();
        return IntStream.range(0, length).map(i -> this.randomInt(baseLength)).mapToObj(number -> String.valueOf(baseString.charAt(number))).collect(Collectors.joining());
    }

    public final int randomInt() {
        return this.getRandom().nextInt();
    }

    public final int randomInt(int exclude) {
        return this.getRandom().nextInt(exclude);
    }

    public final int randomInt(int minInclude, int maxExclude) {
        return this.randomInt(minInclude, maxExclude, true, false);
    }

    public final int randomInt(int min, int max, boolean includeMin, boolean includeMax) {
        if (!includeMin) {
            ++min;
        }
        if (includeMax) {
            ++max;
        }
        return this.getRandom().nextInt(min, max);
    }

    private ThreadLocalRandom getRandom() {
        return ThreadLocalRandom.current();
    }
}

