/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.util;

import cn.hamm.airpower.exception.ServiceException;
import cn.hamm.airpower.interfaces.IDictionary;
import cn.hamm.airpower.interfaces.IFunction;
import cn.hamm.airpower.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class DictionaryUtil {
    private static final Logger log = LoggerFactory.getLogger(DictionaryUtil.class);

    @NotNull
    public final <D extends IDictionary> D getDictionary(@NotNull Class<D> enumClass, int key) {
        return (D)this.getDictionary(enumClass, IDictionary::getKey, key);
    }

    @NotNull
    public final <D extends IDictionary> D getDictionary(@NotNull Class<D> enumClass, Function<D, Object> function, Object value) {
        try {
            IDictionary[] objs;
            for (IDictionary obj : objs = (IDictionary[])enumClass.getEnumConstants()) {
                if (!function.apply(obj).equals(value)) continue;
                return (D)obj;
            }
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
        }
        throw new ServiceException("\u4f20\u5165\u7684\u503c\u4e0d\u5728\u5b57\u5178\u53ef\u9009\u8303\u56f4\u5185");
    }

    @NotNull
    public final <D extends IDictionary> List<Map<String, Object>> getDictionaryList(@NotNull Class<D> clazz) {
        return this.getDictionaryList(clazz, IDictionary::getKey, IDictionary::getLabel);
    }

    @SafeVarargs
    @NotNull
    public final <D extends IDictionary> List<Map<String, Object>> getDictionaryList(@NotNull Class<D> clazz, IFunction<D, Object> ... lambdas) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (IDictionary obj : (IDictionary[])clazz.getEnumConstants()) {
            HashMap item = new HashMap(lambdas.length);
            for (IFunction<D, Object> lambda : lambdas) {
                try {
                    item.put(StringUtils.uncapitalize((String)Utils.getReflectUtil().getLambdaFunctionName(lambda)), lambda.apply(obj));
                }
                catch (Exception exception) {
                    log.error(exception.getMessage(), (Throwable)exception);
                }
            }
            mapList.add(item);
        }
        return mapList;
    }
}

