/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.open;

import cn.hamm.airpower.enums.ServiceError;
import cn.hamm.airpower.exception.ServiceException;
import cn.hamm.airpower.model.Json;
import cn.hamm.airpower.open.IOpenApp;
import cn.hamm.airpower.open.IOpenAppService;
import cn.hamm.airpower.open.IOpenLogService;
import cn.hamm.airpower.open.OpenApi;
import cn.hamm.airpower.open.OpenRequest;
import cn.hamm.airpower.open.OpenResponse;
import cn.hamm.airpower.util.Utils;
import java.lang.reflect.Method;
import java.util.Objects;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Aspect
@Component
public class OpenApiAspect<S extends IOpenAppService, LS extends IOpenLogService> {
    @Autowired(required=false)
    S openAppService;
    @Autowired(required=false)
    LS openLogService;

    @Pointcut(value="@annotation(cn.hamm.airpower.open.OpenApi)")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object openApi(@NotNull ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Object[] args = proceedingJoinPoint.getArgs();
        Signature signature = proceedingJoinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        OpenApi openApi = method.getAnnotation(OpenApi.class);
        ServiceError.API_SERVICE_UNSUPPORTED.whenNull(openApi);
        Long openLogId = null;
        String response = "";
        if (args.length != 1) {
            throw new ServiceException("OpenApi\u5fc5\u987b\u63a5\u6536\u4e00\u4e2a\u53c2\u6570");
        }
        Object object = args[0];
        if (!(object instanceof OpenRequest)) {
            throw new ServiceException("OpenApi\u5fc5\u987b\u63a5\u6536\u4e00\u4e2aOpenRequest\u53c2\u6570");
        }
        OpenRequest openRequest = (OpenRequest)object;
        try {
            IOpenApp openApp = this.getOpenAppFromRequest(openRequest);
            openRequest.setOpenApp(openApp);
            Object object2 = proceedingJoinPoint.proceed();
            openLogId = this.addOpenLog(openRequest.getOpenApp(), Utils.getRequest().getRequestURI(), openRequest.decodeContent());
            openRequest.checkSignature();
            if (object2 instanceof Json) {
                Json json = (Json)object2;
                response = Json.toString(json);
                this.updateLogResponse(openLogId, response);
                json.setData(OpenResponse.encodeResponse(openRequest.getOpenApp(), json.getData()));
            }
            this.updateLogResponse(openLogId, response);
            return object2;
        }
        catch (ServiceException serviceException) {
            response = Json.toString(Json.create().setCode(serviceException.getCode()).setMessage(serviceException.getMessage()));
            this.updateLogResponse(openLogId, response);
            throw serviceException;
        }
        catch (Exception exception) {
            this.updateExceptionResponse(openLogId, exception);
            throw exception;
        }
    }

    @NotNull
    private IOpenApp getOpenAppFromRequest(@NotNull OpenRequest openRequest) {
        ServiceError.INVALID_APP_KEY.when(!StringUtils.hasText((String)openRequest.getAppKey()));
        ServiceError.SERVICE_ERROR.whenNull(this.openAppService, "\u6ce8\u5165OpenAppService\u5931\u8d25");
        IOpenApp openApp = this.openAppService.getByAppKey(openRequest.getAppKey());
        ServiceError.INVALID_APP_KEY.whenNull(openApp);
        return openApp;
    }

    @Nullable
    private Long addOpenLog(IOpenApp openApp, String url, String requestBody) {
        if (Objects.nonNull(this.openLogService)) {
            return this.openLogService.addRequest(openApp, url, requestBody);
        }
        return null;
    }

    private void updateLogResponse(Long openLogId, String responseBody) {
        if (Objects.isNull(openLogId) || Objects.isNull(this.openLogService)) {
            return;
        }
        this.openLogService.updateResponse(openLogId, responseBody);
    }

    private void updateExceptionResponse(Long openLogId, Exception exception) {
        if (Objects.isNull(openLogId)) {
            return;
        }
        this.updateLogResponse(openLogId, Json.toString(Json.create().setMessage(exception.getMessage())));
    }
}

