/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.interceptor.cache;

import cn.hamm.airpower.interceptor.cache.RequestBodyCacheWrapper;
import cn.hamm.airpower.util.Utils;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;

@Component
@WebFilter
public class RequestCacheFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(RequestCacheFilter.class);

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) {
        try {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            if (!this.requestCacheRequired(request)) {
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            RequestBodyCacheWrapper wrapper = new RequestBodyCacheWrapper(request);
            filterChain.doFilter((ServletRequest)wrapper, servletResponse);
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
        }
    }

    private boolean requestCacheRequired(@NotNull HttpServletRequest request) {
        if (HttpMethod.GET.name().equalsIgnoreCase(request.getMethod())) {
            return false;
        }
        String contentType = request.getContentType();
        if (Objects.isNull(contentType) || !contentType.contains("application/json")) {
            return false;
        }
        return !Utils.getRequestUtil().isUploadRequest(request);
    }
}

