/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.datasource;

import cn.hamm.airpower.config.Configs;
import cn.hamm.airpower.datasource.DataSourceResolver;
import jakarta.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class DataSourceAspect {
    @Pointcut(value="@annotation(org.springframework.web.bind.annotation.PostMapping)||@annotation(org.springframework.web.bind.annotation.GetMapping)||@annotation(org.springframework.web.bind.annotation.RequestMapping)")
    public void pointCut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="pointCut()")
    public Object multipleDataSource(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        String database = request.getHeader(Configs.getServiceConfig().getTenantHeader());
        if (!StringUtils.hasText((String)database)) {
            return proceedingJoinPoint.proceed();
        }
        DataSourceResolver.setDataSourceParam(database);
        try {
            Object object = proceedingJoinPoint.proceed();
            return object;
        }
        finally {
            DataSourceResolver.clearDataSourceParam();
        }
    }
}

