/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.websocket;

import cn.hamm.airpower.config.Configs;
import cn.hamm.airpower.exception.ServiceException;
import cn.hamm.airpower.model.Json;
import cn.hamm.airpower.util.Utils;
import cn.hamm.airpower.websocket.WebSocketEvent;
import cn.hamm.airpower.websocket.WebSocketPayload;
import java.util.Objects;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class WebsocketUtil {
    private static final Logger log = LoggerFactory.getLogger(WebsocketUtil.class);

    @NotNull
    public final WebSocketEvent publish(WebSocketPayload payload) {
        return this.publishToChannel("WEBSOCKET_ALL", payload);
    }

    @NotNull
    public final WebSocketEvent publishToUser(long userId, WebSocketPayload payload) {
        return this.publishToChannel("WEBSOCKET_USER_" + userId, payload);
    }

    @NotNull
    public final WebSocketEvent publishToChannel(String channel, WebSocketPayload payload) {
        String channelPrefix = Configs.getWebsocketConfig().getChannelPrefix();
        if (Objects.isNull(channelPrefix) || !StringUtils.hasText((String)channelPrefix)) {
            throw new ServiceException("\u6ca1\u6709\u914d\u7f6e airpower.websocket.channelPrefix, \u65e0\u6cd5\u542f\u52a8WebSocket\u670d\u52a1");
        }
        String targetChannel = channelPrefix + "_" + channel;
        WebSocketEvent event = WebSocketEvent.create(payload);
        log.info("\u53d1\u5e03\u6d88\u606f\u5230\u9891\u9053 {} : {}", (Object)targetChannel, (Object)Json.toString(event));
        switch (Configs.getWebsocketConfig().getSupport()) {
            case REDIS: {
                Utils.getRedisUtil().publish(targetChannel, Json.toString(event));
                break;
            }
            case MQTT: {
                try {
                    Utils.getMqttUtil().publish(targetChannel, Json.toString(event));
                    break;
                }
                catch (MqttException e) {
                    throw new RuntimeException("\u53d1\u5e03\u6d88\u606f\u5931\u8d25", e);
                }
            }
            default: {
                throw new RuntimeException("WebSocket\u6682\u4e0d\u652f\u6301");
            }
        }
        return event;
    }
}

