/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.websocket;

import cn.hamm.airpower.config.Configs;
import cn.hamm.airpower.exception.ServiceException;
import cn.hamm.airpower.model.Json;
import cn.hamm.airpower.util.Utils;
import cn.hamm.airpower.websocket.WebSocketEvent;
import cn.hamm.airpower.websocket.WebSocketPayload;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Objects;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.Subscription;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

@Component
public class WebSocketHandler
extends TextWebSocketHandler
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger(WebSocketHandler.class);
    public static final String CHANNEL_ALL = "WEBSOCKET_ALL";
    public static final String CHANNEL_USER_PREFIX = "WEBSOCKET_USER_";
    protected final HashMap<String, RedisConnection> redisConnectionHashMap = new HashMap();
    protected final HashMap<String, MqttClient> mqttClientHashMap = new HashMap();
    protected final HashMap<String, Long> userIdHashMap = new HashMap();
    @Autowired
    private RedisConnectionFactory redisConnectionFactory;

    protected final void handleTextMessage(@NonNull WebSocketSession session, @NotNull TextMessage textMessage) {
        String message = (String)textMessage.getPayload();
        if (Configs.getWebsocketConfig().getPing().equalsIgnoreCase(message)) {
            try {
                session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)Configs.getWebsocketConfig().getPong()));
            }
            catch (IOException e) {
                log.error("\u53d1\u9001Websocket\u6d88\u606f\u5931\u8d25: {}", (Object)e.getMessage());
            }
            return;
        }
        try {
            WebSocketPayload webSocketPayload = Json.parse(message, WebSocketPayload.class);
            this.onWebSocketPayload(webSocketPayload, session);
        }
        catch (Exception exception) {
            log.error("\u89e3\u6790Websocket\u4e8b\u4ef6\u8d1f\u8f7d\u5931\u8d25: {}", (Object)exception.getMessage());
        }
    }

    protected final void sendWebSocketPayload(@NotNull WebSocketSession session, @NotNull WebSocketPayload webSocketPayload) {
        try {
            session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)Json.toString(WebSocketEvent.create(webSocketPayload))));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void onWebSocketPayload(@NotNull WebSocketPayload webSocketPayload, @NotNull WebSocketSession session) {
        log.info("\u8d1f\u8f7d\u7c7b\u578b: {}, \u8d1f\u8f7d\u5185\u5bb9: {}", (Object)webSocketPayload.getType(), (Object)webSocketPayload.getData());
    }

    public final void afterConnectionEstablished(@NonNull WebSocketSession session) {
        if (Objects.isNull(session.getUri())) {
            return;
        }
        String accessToken = session.getUri().getQuery();
        if (Objects.isNull(accessToken)) {
            log.warn("\u6ca1\u6709\u4f20\u5165AccessToken \u5373\u5c06\u5173\u95ed\u8fde\u63a5");
            this.closeConnection(session);
            return;
        }
        long userId = Utils.getSecurityUtil().getIdFromAccessToken(accessToken);
        switch (Configs.getWebsocketConfig().getSupport()) {
            case REDIS: {
                this.startRedisListener(session, userId);
                break;
            }
            case MQTT: {
                this.startMqttListener(session, userId);
                break;
            }
            default: {
                throw new RuntimeException("WebSocket\u6682\u4e0d\u652f\u6301");
            }
        }
        this.userIdHashMap.put(session.getId(), userId);
    }

    private void onChannelMessage(@NotNull String message, @NonNull WebSocketSession session) {
        try {
            session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)message));
        }
        catch (Exception exception) {
            log.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25", (Throwable)exception);
        }
    }

    private void startRedisListener(@NotNull WebSocketSession session, long userId) {
        String personalChannel = this.getRealChannel(CHANNEL_USER_PREFIX + userId);
        RedisConnection redisConnection = this.redisConnectionFactory.getConnection();
        this.redisConnectionHashMap.put(session.getId(), redisConnection);
        redisConnection.subscribe((message, pattern) -> {
            WebSocketSession webSocketSession = session;
            synchronized (webSocketSession) {
                this.onChannelMessage(new String(message.getBody(), StandardCharsets.UTF_8), session);
            }
        }, (byte[][])new byte[][]{this.getRealChannel(CHANNEL_ALL).getBytes(StandardCharsets.UTF_8), personalChannel.getBytes(StandardCharsets.UTF_8)});
    }

    private void startMqttListener(final @NotNull WebSocketSession session, long userId) {
        try (MqttClient mqttClient = Utils.getMqttUtil().createClient();){
            mqttClient.setCallback(new MqttCallback(){

                public void connectionLost(Throwable throwable) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void messageArrived(String topic, MqttMessage mqttMessage) {
                    WebSocketSession webSocketSession = session;
                    synchronized (webSocketSession) {
                        WebSocketHandler.this.onChannelMessage(new String(mqttMessage.getPayload(), StandardCharsets.UTF_8), session);
                    }
                }

                public void deliveryComplete(IMqttDeliveryToken iMqttDeliveryToken) {
                }
            });
            mqttClient.connect(Utils.getMqttUtil().createOption());
            String personalChannel = CHANNEL_USER_PREFIX + userId;
            String[] topics = new String[]{CHANNEL_ALL, personalChannel};
            mqttClient.subscribe(topics);
            this.mqttClientHashMap.put(session.getId(), mqttClient);
        }
        catch (MqttException e) {
            throw new ServiceException((Exception)((Object)e));
        }
    }

    private void closeConnection(@NotNull WebSocketSession session) {
        try {
            session.close();
        }
        catch (IOException e) {
            log.error("\u5173\u95edWebsocket\u5931\u8d25");
        }
    }

    @Contract(pure=true)
    public final void afterConnectionClosed(@NotNull WebSocketSession session, @NotNull CloseStatus status) {
        try {
            RedisConnection redisConnection = this.redisConnectionHashMap.get(session.getId());
            if (Objects.nonNull(redisConnection)) {
                redisConnection.close();
            }
            this.redisConnectionHashMap.remove(session.getId());
            MqttClient mqttClient = this.mqttClientHashMap.get(session.getId());
            if (Objects.nonNull(mqttClient)) {
                mqttClient.close();
                this.mqttClientHashMap.remove(session.getId());
            }
            this.userIdHashMap.remove(session.getId());
        }
        catch (Exception exception) {
            log.error(exception.getMessage());
        }
    }

    @Contract(pure=true)
    public final void onMessage(@NotNull Message message, byte[] pattern) {
    }

    protected final void redisSubscribe(@NotNull String channel, WebSocketSession session) {
        log.info("REDIS\u5f00\u59cb\u8ba2\u9605\u9891\u9053: {}", (Object)this.getRealChannel(channel));
        this.getRedisSubscription(session).subscribe((byte[][])new byte[][]{this.getRealChannel(channel).getBytes(StandardCharsets.UTF_8)});
    }

    protected final void mqttSubscribe(String channel, WebSocketSession session) {
        log.info("MQTT\u5f00\u59cb\u8ba2\u9605\u9891\u9053: {}", (Object)this.getRealChannel(channel));
        try {
            this.getMqttClient(session).subscribe(this.getRealChannel(channel));
        }
        catch (MqttException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    protected final String getRealChannel(String channel) {
        return Configs.getWebsocketConfig().getChannelPrefix() + "_" + channel;
    }

    protected final void redisUnSubscribe(@NotNull String channel, WebSocketSession session) {
        log.info("REDIS\u53d6\u6d88\u8ba2\u9605\u9891\u9053: {}", (Object)this.getRealChannel(channel));
        this.getRedisSubscription(session).unsubscribe((byte[][])new byte[][]{this.getRealChannel(channel).getBytes(StandardCharsets.UTF_8)});
    }

    protected final void mqttUnSubscribe(String channel, WebSocketSession session) {
        log.info("MQTT\u53d6\u6d88\u8ba2\u9605\u9891\u9053: {}", (Object)this.getRealChannel(channel));
        try {
            this.getMqttClient(session).unsubscribe(this.getRealChannel(channel));
        }
        catch (MqttException e) {
            throw new RuntimeException(e);
        }
    }

    protected final MqttClient getMqttClient(@NotNull WebSocketSession session) {
        MqttClient mqttClient = this.mqttClientHashMap.get(session.getId());
        if (Objects.isNull(mqttClient)) {
            throw new RuntimeException("mqtt client is null");
        }
        return mqttClient;
    }

    protected final Subscription getRedisSubscription(@NotNull WebSocketSession session) {
        RedisConnection redisConnection = this.redisConnectionHashMap.get(session.getId());
        if (Objects.isNull(redisConnection)) {
            throw new RuntimeException("redisConnection is null");
        }
        Subscription subscription = redisConnection.getSubscription();
        if (Objects.isNull(subscription)) {
            throw new RuntimeException("subscription is null");
        }
        return subscription;
    }
}

