/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.websocket;

import cn.hamm.airpower.config.Configs;
import cn.hamm.airpower.websocket.WebSocketPayload;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

public class WebSocketEvent {
    private static final AtomicLong CURRENT_EVENT_ID = new AtomicLong(0L);
    private String id;
    private long from = 0L;
    private long to = 0L;
    private Long time;
    private WebSocketPayload payload;

    protected final void resetEvent() {
        long time = System.currentTimeMillis();
        this.time = time;
        this.id = Base64.getEncoder().encodeToString(String.format("%s-%s-%s", Configs.getServiceConfig().getServiceId(), CURRENT_EVENT_ID.incrementAndGet(), time).getBytes(StandardCharsets.UTF_8));
    }

    @NotNull
    public static WebSocketEvent create(WebSocketPayload payload) {
        return WebSocketEvent.create().setPayload(payload);
    }

    @NotNull
    private static WebSocketEvent create() {
        WebSocketEvent webSocketEvent = new WebSocketEvent();
        webSocketEvent.resetEvent();
        return webSocketEvent;
    }

    public String getId() {
        return this.id;
    }

    public long getFrom() {
        return this.from;
    }

    public long getTo() {
        return this.to;
    }

    public Long getTime() {
        return this.time;
    }

    public WebSocketPayload getPayload() {
        return this.payload;
    }

    public WebSocketEvent setId(String id) {
        this.id = id;
        return this;
    }

    public WebSocketEvent setFrom(long from) {
        this.from = from;
        return this;
    }

    public WebSocketEvent setTo(long to) {
        this.to = to;
        return this;
    }

    public WebSocketEvent setTime(Long time) {
        this.time = time;
        return this;
    }

    public WebSocketEvent setPayload(WebSocketPayload payload) {
        this.payload = payload;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebSocketEvent)) {
            return false;
        }
        WebSocketEvent other = (WebSocketEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFrom() != other.getFrom()) {
            return false;
        }
        if (this.getTo() != other.getTo()) {
            return false;
        }
        Long this$time = this.getTime();
        Long other$time = other.getTime();
        if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        WebSocketPayload this$payload = this.getPayload();
        WebSocketPayload other$payload = other.getPayload();
        return !(this$payload == null ? other$payload != null : !((Object)this$payload).equals(other$payload));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WebSocketEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $from = this.getFrom();
        result = result * 59 + (int)($from >>> 32 ^ $from);
        long $to = this.getTo();
        result = result * 59 + (int)($to >>> 32 ^ $to);
        Long $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        WebSocketPayload $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : ((Object)$payload).hashCode());
        return result;
    }

    public String toString() {
        return "WebSocketEvent(id=" + this.getId() + ", from=" + this.getFrom() + ", to=" + this.getTo() + ", time=" + this.getTime() + ", payload=" + this.getPayload() + ")";
    }
}

