/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TaskUtil {
    private static final Logger log = LoggerFactory.getLogger(TaskUtil.class);

    public final void run(Runnable runnable, Runnable ... moreRunnable) {
        for (Runnable run : this.getRunnableList(runnable, moreRunnable)) {
            try {
                run.run();
            }
            catch (Exception exception) {
                log.error(exception.getMessage(), (Throwable)exception);
            }
        }
    }

    public final void runAsync(Runnable runnable, Runnable ... moreRunnable) {
        for (Runnable run : this.getRunnableList(runnable, moreRunnable)) {
            new Thread(run).start();
        }
    }

    @NotNull
    private List<Runnable> getRunnableList(Runnable runnable, Runnable[] moreRunnable) {
        ArrayList<Runnable> runnableList = new ArrayList<Runnable>();
        runnableList.add(runnable);
        runnableList.addAll(Arrays.asList(moreRunnable));
        return runnableList;
    }
}

