/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.util;

import cn.hamm.airpower.annotation.Desensitize;
import cn.hamm.airpower.util.Utils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class StringUtil {
    private static final int IPV4_PART_COUNT = 4;

    @NotNull
    public final String replace(String text, int head, int tail, String symbol) {
        if (head < 0 || tail < 0) {
            return text;
        }
        if (head + tail >= text.length()) {
            return text;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            if (i >= head && i <= text.length() - tail - 1) {
                stringBuilder.append(symbol);
                continue;
            }
            stringBuilder.append(text.charAt(i));
        }
        return stringBuilder.toString();
    }

    @NotNull
    public final String desensitizeIpv4Address(@NotNull String ipv4, String symbol) {
        CharSequence[] strings;
        if (!StringUtils.hasText((String)symbol)) {
            symbol = "*";
        }
        if ((strings = ipv4.split("\\.")).length != 4) {
            return ipv4;
        }
        strings[1] = symbol + symbol + symbol;
        strings[2] = strings[1];
        return String.join((CharSequence)".", strings);
    }

    @NotNull
    public final String desensitizeIpv4Address(@NotNull String ipv4) {
        return this.desensitizeIpv4Address(ipv4, "*");
    }

    @Contract(pure=true)
    @NotNull
    public final String desensitize(@NotNull String text, Desensitize.Type type, int head, int tail) {
        return this.desensitize(text, type, head, tail, "*");
    }

    @Contract(pure=true)
    @NotNull
    public final String desensitize(@NotNull String valueString,  @NotNull Desensitize.Type type, int head, int tail, String symbol) {
        switch (type) {
            case CHINESE_NAME: {
                head = Math.max(1, head);
                tail = Math.max(1, tail);
                if (valueString.length() > head + tail) break;
                tail = 0;
                break;
            }
            case BANK_CARD: {
                head = Math.max(4, head);
                tail = Math.max(4, tail);
                break;
            }
            case ID_CARD: {
                head = Math.max(6, head);
                tail = Math.max(4, tail);
                break;
            }
            case MOBILE: {
                head = Math.max(3, head);
                tail = Math.max(4, tail);
                break;
            }
            case EMAIL: {
                head = 2;
                tail = 2;
                break;
            }
            case IP_V4: {
                return Utils.getStringUtil().desensitizeIpv4Address(valueString, symbol);
            }
            case ADDRESS: {
                head = Math.max(3, head);
                tail = Math.max(0, tail);
                break;
            }
            case TELEPHONE: {
                if (valueString.length() <= 8) {
                    head = Math.max(2, head);
                    tail = Math.max(2, tail);
                    break;
                }
                head = Math.max(4, head);
                tail = Math.max(4, tail);
                break;
            }
            case CAR_NUMBER: {
                head = Math.max(2, head);
                tail = Math.max(1, tail);
                break;
            }
        }
        return Utils.getStringUtil().replace(valueString, head, tail, symbol);
    }
}

