/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.util;

import cn.hamm.airpower.config.Configs;
import jakarta.servlet.http.Cookie;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class CookieUtil {
    @NotNull
    public final Cookie getCookie(String key, String value) {
        Cookie cookie = new Cookie(key, value);
        cookie.setHttpOnly(Configs.getCookieConfig().isCookieHttpOnly());
        cookie.setMaxAge(Configs.getCookieConfig().getCookieMaxAge());
        cookie.setSecure(Configs.getCookieConfig().isCookieSecurity());
        cookie.setPath(cookie.getPath());
        return cookie;
    }

    @NotNull
    public final Cookie getAuthorizeCookie(String value) {
        return this.getCookie(Configs.getCookieConfig().getAuthCookieName(), value);
    }
}

