/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.util;

import cn.hamm.airpower.exception.ServiceException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class AesUtil {
    private static final int KEY_SIZE = 256;
    private static final String AES = "AES";
    private static final String AES_CBC_PKCS5_PADDING = "AES/CBC/PKCS5Padding";
    private byte[] key;
    private byte[] iv = "0000000000000000".getBytes(StandardCharsets.UTF_8);
    private String algorithm = "AES/CBC/PKCS5Padding";

    public AesUtil setIv(String iv) {
        this.iv = Base64.getDecoder().decode(iv);
        return this;
    }

    public AesUtil setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public AesUtil setKey(String key) {
        this.key = Base64.getDecoder().decode(key);
        return this;
    }

    public final String encrypt(String source) {
        try {
            return Base64.getEncoder().encodeToString(this.getCipher(1).doFinal(source.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Contract(value="_ -> new")
    @NotNull
    public final String decrypt(String content) {
        try {
            return new String(this.getCipher(2).doFinal(Base64.getDecoder().decode(content)), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private Cipher getCipher(int mode) {
        System.out.println(this.key.length);
        System.out.println(new String(this.key));
        System.out.println(this.iv.length);
        System.out.println(new String(this.iv));
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.key, AES);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(this.iv);
            Cipher cipher = Cipher.getInstance(this.algorithm);
            cipher.init(mode, (Key)secretKeySpec, ivParameterSpec);
            return cipher;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Contract(value=" -> new")
    @NotNull
    public static String getRandomKey() {
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance(AES);
            keyGen.init(256, new SecureRandom());
            SecretKey aesKey = keyGen.generateKey();
            byte[] keyBytes = aesKey.getEncoded();
            return Base64.getEncoder().encodeToString(keyBytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ServiceException(e);
        }
    }

    @Contract(value=" -> new")
    @NotNull
    public static String getRandomIv() {
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance(AES);
            keyGen.init(128, new SecureRandom());
            SecretKey aesKey = keyGen.generateKey();
            byte[] keyBytes = aesKey.getEncoded();
            return Base64.getEncoder().encodeToString(keyBytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ServiceException(e);
        }
    }
}

