/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.util;

import cn.hamm.airpower.annotation.ApiController;
import cn.hamm.airpower.annotation.Extends;
import cn.hamm.airpower.annotation.Permission;
import cn.hamm.airpower.enums.Api;
import cn.hamm.airpower.interfaces.IPermission;
import cn.hamm.airpower.model.Access;
import cn.hamm.airpower.util.Utils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Component
public class AccessUtil {
    private static final Logger log = LoggerFactory.getLogger(AccessUtil.class);
    private static final String CONTROLLER_CLASS_PATH = "/**/*Controller.class";

    @NotNull
    public final Access getWhatNeedAccess(@NotNull Class<?> clazz, @NotNull Method method) {
        Permission permissionMethod;
        Access access = new Access();
        Permission permissionClass = clazz.getAnnotation(Permission.class);
        if (Objects.nonNull(permissionClass)) {
            access.setLogin(permissionClass.login());
            access.setAuthorize(permissionClass.login() && permissionClass.authorize());
        }
        if (Objects.nonNull(permissionMethod = method.getAnnotation(Permission.class))) {
            access.setLogin(permissionMethod.login());
            access.setAuthorize(permissionMethod.login() && permissionMethod.authorize());
        }
        return access;
    }

    @NotNull
    public final String getPermissionIdentity(@NotNull Class<?> clazz, @NotNull Method method) {
        return StringUtils.uncapitalize((String)clazz.getSimpleName().replaceAll("Controller", "")) + "_" + method.getName();
    }

    @NotNull
    public final <P extends IPermission<P>> List<P> scanPermission(@NotNull Class<?> clazz, Class<P> permissionClass) {
        return this.scanPermission(clazz.getPackageName(), permissionClass);
    }

    @NotNull
    public final <P extends IPermission<P>> List<P> scanPermission(String packageName, Class<P> permissionClass) {
        ArrayList<IPermission> permissions = new ArrayList<IPermission>();
        try {
            PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
            String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)packageName) + CONTROLLER_CLASS_PATH;
            Resource[] resources = resourcePatternResolver.getResources(pattern);
            CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)resourcePatternResolver);
            for (Resource resource : resources) {
                MetadataReader metadataReader = metadataReaderFactory.getMetadataReader(resource);
                String className = metadataReader.getClassMetadata().getClassName();
                Class<?> clazz = Class.forName(className);
                ApiController apiController = Utils.getReflectUtil().getAnnotation(ApiController.class, clazz);
                if (Objects.isNull(apiController)) continue;
                String customClassName = Utils.getReflectUtil().getDescription(clazz);
                String identity = clazz.getSimpleName().replaceAll("Controller", "");
                IPermission permission = (IPermission)permissionClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                ((IPermission)permission.setName(customClassName)).setIdentity(identity);
                permission.setChildren(new ArrayList());
                String apiPath = apiController.value();
                Method[] methods = clazz.getMethods();
                Extends extendsApi = Utils.getReflectUtil().getAnnotation(Extends.class, clazz);
                for (Method method : methods) {
                    Access accessConfig;
                    if (Objects.nonNull(extendsApi)) {
                        try {
                            Api current = Utils.getDictionaryUtil().getDictionary(Api.class, Api::getMethodName, method.getName());
                            if (this.checkApiExcluded(current, extendsApi)) {
                                continue;
                            }
                        }
                        catch (Exception current) {
                            // empty catch block
                        }
                    }
                    String customMethodName = Utils.getReflectUtil().getDescription(method);
                    Object subIdentity = !"".equalsIgnoreCase(apiPath) ? apiPath + "_" : "";
                    RequestMapping requestMapping = Utils.getReflectUtil().getAnnotation(RequestMapping.class, method);
                    PostMapping postMapping = Utils.getReflectUtil().getAnnotation(PostMapping.class, method);
                    GetMapping getMapping = Utils.getReflectUtil().getAnnotation(GetMapping.class, method);
                    if (Objects.nonNull(requestMapping) && requestMapping.value().length > 0) {
                        subIdentity = (String)subIdentity + requestMapping.value()[0];
                    } else if (Objects.nonNull(postMapping) && postMapping.value().length > 0) {
                        subIdentity = (String)subIdentity + postMapping.value()[0];
                    } else if (Objects.nonNull(getMapping) && getMapping.value().length > 0) {
                        subIdentity = (String)subIdentity + getMapping.value()[0];
                    }
                    if (!StringUtils.hasText((String)subIdentity) || (apiPath + "_").equals(subIdentity) || !(accessConfig = Utils.getAccessUtil().getWhatNeedAccess(clazz, method)).isLogin() || !accessConfig.isAuthorize()) continue;
                    IPermission subPermission = (IPermission)permissionClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    subPermission.setIdentity((String)subIdentity).setName(customClassName + "-" + customMethodName);
                    permission.getChildren().add(subPermission);
                }
                permissions.add(permission);
            }
        }
        catch (Exception exception) {
            log.error("\u626b\u63cf\u6743\u9650\u51fa\u9519", (Throwable)exception);
        }
        return permissions;
    }

    private boolean checkApiExcluded(Api api, @NotNull Extends extend) {
        List<Api> excludeList = Arrays.asList(extend.exclude());
        List<Api> includeList = Arrays.asList(extend.value());
        if (excludeList.contains(api)) {
            return true;
        }
        if (includeList.isEmpty()) {
            return false;
        }
        return !includeList.contains(api);
    }
}

