/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.root;

import cn.hamm.airpower.annotation.Desensitize;
import cn.hamm.airpower.annotation.Exclude;
import cn.hamm.airpower.annotation.Expose;
import cn.hamm.airpower.annotation.Filter;
import cn.hamm.airpower.annotation.Payload;
import cn.hamm.airpower.exception.ServiceException;
import cn.hamm.airpower.interfaces.IAction;
import cn.hamm.airpower.util.Utils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class RootModel<M extends RootModel<M>>
implements IAction {
    private static final Logger log = LoggerFactory.getLogger(RootModel.class);

    @NotNull
    public final M copy() {
        try {
            RootModel target = (RootModel)this.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            BeanUtils.copyProperties((Object)this, (Object)target);
            return (M)target;
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            throw new ServiceException(exception);
        }
    }

    public final M filterAndDesensitize(@NotNull Class<?> filterClass, boolean isDesensitize) {
        Class<?> clazz = this.getClass();
        List<Field> allFields = Utils.getReflectUtil().getFieldList(clazz);
        Exclude exclude = clazz.getAnnotation(Exclude.class);
        BiConsumer<@NotNull Field, @NotNull Class> task = Objects.nonNull(exclude) ? this::exposeBy : this::excludeBy;
        Consumer<@NotNull Field> desensitize = this::desensitize;
        allFields.forEach(field -> {
            if (!Void.class.equals((Object)filterClass)) {
                task.accept((Field)field, filterClass);
                this.filterFieldPayload((Field)field, isDesensitize);
            }
            if (isDesensitize) {
                desensitize.accept((Field)field);
            }
        });
        return (M)this;
    }

    public final M filterAndDesensitize(@Nullable Filter filter, boolean isDesensitize) {
        if (Objects.isNull(filter)) {
            return this.filterAndDesensitize(Void.class, isDesensitize);
        }
        return this.filterAndDesensitize(filter.value(), isDesensitize);
    }

    private void excludeBy(@NotNull Field field, @NotNull Class<?> filterClass) {
        Exclude fieldExclude = Utils.getReflectUtil().getAnnotation(Exclude.class, field);
        if (Objects.isNull(fieldExclude)) {
            return;
        }
        Class<?>[] excludeClasses = fieldExclude.filters();
        boolean isNeedClear = true;
        if (excludeClasses.length > 0) {
            isNeedClear = Arrays.asList(excludeClasses).contains(filterClass);
        }
        if (isNeedClear) {
            Utils.getReflectUtil().clearFieldValue(this, field);
        }
    }

    private void exposeBy(@NotNull Field field, @NotNull Class<?> filterClass) {
        Expose fieldExpose = Utils.getReflectUtil().getAnnotation(Expose.class, field);
        if (Objects.isNull(fieldExpose)) {
            Utils.getReflectUtil().clearFieldValue(this, field);
            return;
        }
        Class<?>[] exposeClasses = fieldExpose.filters();
        if (exposeClasses.length == 0) {
            return;
        }
        boolean isExpose = Arrays.asList(exposeClasses).contains(filterClass);
        if (!isExpose) {
            Utils.getReflectUtil().clearFieldValue(this, field);
        }
    }

    private void filterFieldPayload(@NotNull Field field, boolean isDesensitize) {
        Payload payload = Utils.getReflectUtil().getAnnotation(Payload.class, field);
        if (Objects.isNull(payload)) {
            return;
        }
        Object fieldValue = Utils.getReflectUtil().getFieldValue(this, field);
        if (fieldValue instanceof Collection) {
            Class<?> fieldClass = field.getType();
            Collection<RootModel> collection = Utils.getCollectionUtil().getCollectWithoutNull((Collection)fieldValue, fieldClass);
            collection.forEach(item -> item.filterAndDesensitize(IAction.WhenPayLoad.class, isDesensitize));
            Utils.getReflectUtil().setFieldValue(this, field, collection);
            return;
        }
        if (Objects.isNull(fieldValue)) {
            return;
        }
        Utils.getReflectUtil().setFieldValue(this, field, ((RootModel)fieldValue).filterAndDesensitize(IAction.WhenPayLoad.class, isDesensitize));
    }

    private void desensitize(@NotNull Field field) {
        Desensitize desensitize = Utils.getReflectUtil().getAnnotation(Desensitize.class, field);
        if (Objects.isNull(desensitize)) {
            return;
        }
        Object value = Utils.getReflectUtil().getFieldValue(this, field);
        if (Objects.isNull(value)) {
            return;
        }
        if (!(value instanceof String)) {
            return;
        }
        String valueString = (String)value;
        Utils.getReflectUtil().setFieldValue(this, field, Utils.getStringUtil().desensitize(valueString, desensitize.value(), desensitize.head(), desensitize.tail(), desensitize.symbol()));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RootModel)) {
            return false;
        }
        RootModel other = (RootModel)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof RootModel;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

