/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.open;

import cn.hamm.airpower.enums.ServiceError;
import cn.hamm.airpower.exception.ServiceException;
import cn.hamm.airpower.model.Json;
import cn.hamm.airpower.open.IOpenApp;
import cn.hamm.airpower.open.OpenArithmeticType;
import cn.hamm.airpower.util.Utils;
import java.util.Objects;

public class OpenResponse {
    public static <A extends IOpenApp> String encodeResponse(A openApp, Object data) {
        if (Objects.isNull(data)) {
            return null;
        }
        String response = Json.toString(data);
        OpenArithmeticType appArithmeticType = Utils.getDictionaryUtil().getDictionary(OpenArithmeticType.class, openApp.getArithmetic());
        try {
            switch (appArithmeticType) {
                case AES: {
                    response = Utils.getAesUtil().setKey(openApp.getAppSecret()).encrypt(response);
                    break;
                }
                case RSA: {
                    response = Utils.getRsaUtil().setPrivateKey(openApp.getPrivateKey()).publicKeyEncrypt(response);
                    break;
                }
                case NO: {
                    break;
                }
                default: {
                    throw new ServiceException(ServiceError.ENCRYPT_DATA_FAIL, "\u4e0d\u652f\u6301\u7684\u52a0\u5bc6\u7b97\u6cd5");
                }
            }
        }
        catch (Exception e) {
            ServiceError.ENCRYPT_DATA_FAIL.show();
        }
        return response;
    }
}

