/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.open;

import cn.hamm.airpower.enums.ServiceError;
import cn.hamm.airpower.exception.ServiceException;
import cn.hamm.airpower.model.Json;
import cn.hamm.airpower.open.IOpenApp;
import cn.hamm.airpower.open.OpenArithmeticType;
import cn.hamm.airpower.root.RootModel;
import cn.hamm.airpower.util.Utils;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenRequest {
    private static final Logger log = LoggerFactory.getLogger(OpenRequest.class);
    private static final String NONCE_CACHE_PREFIX = "NONCE_";
    private static final int NONCE_CACHE_SECOND = 60;
    @NotBlank(message="AppKey\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotBlank(message="AppKey\u4e0d\u80fd\u4e3a\u7a7a") String appKey;
    @NotNull(message="\u7248\u672c\u53f7\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u7248\u672c\u53f7\u4e0d\u80fd\u4e3a\u7a7a") int version;
    @NotNull(message="\u8bf7\u6c42\u6beb\u79d2\u65f6\u95f4\u6233\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u8bf7\u6c42\u6beb\u79d2\u65f6\u95f4\u6233\u4e0d\u80fd\u4e3a\u7a7a") long timestamp;
    @NotNull(message="\u4e1a\u52a1\u6570\u636e\u5305\u4f53\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u4e1a\u52a1\u6570\u636e\u5305\u4f53\u4e0d\u80fd\u4e3a\u7a7a") String content;
    @NotNull(message="\u7b7e\u540d\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u7b7e\u540d\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a") String signature;
    @NotNull(message="\u8bf7\u6c42\u968f\u673a\u4e32\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u8bf7\u6c42\u968f\u673a\u4e32\u4e0d\u80fd\u4e3a\u7a7a") String nonce;
    private IOpenApp openApp;

    public final void checkSignature() {
        ServiceError.SIGNATURE_INVALID.whenNotEquals(this.signature, this.sign());
        this.checkNonce();
        this.checkTimestamp();
    }

    @org.jetbrains.annotations.NotNull
    public final String sign() {
        return DigestUtils.sha1Hex((String)(this.openApp.getAppSecret() + this.appKey + this.version + this.timestamp + this.nonce + this.content));
    }

    public final <T extends RootModel<T>> T parse(Class<T> clazz) {
        try {
            return (T)((RootModel)Json.parse(this.decodeContent(), clazz));
        }
        catch (Exception e) {
            ServiceError.JSON_DECODE_FAIL.show();
            throw new ServiceException(e);
        }
    }

    public final String decodeContent() {
        String request = this.content;
        OpenArithmeticType appArithmeticType = Utils.getDictionaryUtil().getDictionary(OpenArithmeticType.class, this.openApp.getArithmetic());
        try {
            switch (appArithmeticType) {
                case AES: {
                    request = Utils.getAesUtil().setKey(this.openApp.getAppSecret()).decrypt(request);
                    break;
                }
                case RSA: {
                    request = Utils.getRsaUtil().setPrivateKey(this.openApp.getPrivateKey()).privateKeyDecrypt(request);
                    break;
                }
                case NO: {
                    break;
                }
                default: {
                    throw new ServiceException("\u89e3\u5bc6\u5931\u8d25\uff0c\u4e0d\u652f\u6301\u7684\u52a0\u5bc6\u7b97\u6cd5\u7c7b\u578b");
                }
            }
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            ServiceError.DECRYPT_DATA_FAIL.show();
        }
        return request;
    }

    private void checkTimestamp() {
        ServiceError.TIMESTAMP_INVALID.when(this.timestamp > System.currentTimeMillis() + 60000L || this.timestamp < System.currentTimeMillis() - 60000L);
    }

    private void checkNonce() {
        Object savedNonce = Utils.getRedisUtil().get(NONCE_CACHE_PREFIX + this.nonce);
        ServiceError.REPEAT_REQUEST.whenNotNull(savedNonce);
        Utils.getRedisUtil().set(NONCE_CACHE_PREFIX + this.nonce, 1, 60L);
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public void setOpenApp(IOpenApp openApp) {
        this.openApp = openApp;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public IOpenApp getOpenApp() {
        return this.openApp;
    }
}

