/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.interceptor.cache;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class RequestBodyCacheWrapper
extends HttpServletRequestWrapper {
    private final byte[] cachedBody;

    public RequestBodyCacheWrapper(HttpServletRequest request) throws IOException {
        super(request);
        this.cachedBody = this.inputStreamToBytes((InputStream)request.getInputStream());
    }

    @Contract(value=" -> new")
    @NotNull
    public final ServletInputStream getInputStream() {
        return new CachedServletInputStream(new ByteArrayInputStream(this.cachedBody));
    }

    @Contract(value=" -> new")
    @NotNull
    public final BufferedReader getReader() {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), StandardCharsets.UTF_8));
    }

    private byte[] inputStreamToBytes(@NotNull InputStream inputStream) throws IOException {
        int read;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((read = inputStream.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
        return out.toByteArray();
    }

    private static class CachedServletInputStream
    extends ServletInputStream {
        private final ByteArrayInputStream inputStream;

        public CachedServletInputStream(ByteArrayInputStream inputStream) {
            this.inputStream = inputStream;
        }

        public final int read() {
            return this.inputStream.read();
        }

        @Contract(pure=true)
        public final boolean isFinished() {
            return false;
        }

        @Contract(pure=true)
        public final boolean isReady() {
            return true;
        }

        @Contract(pure=true)
        public final void setReadListener(ReadListener readListener) {
        }
    }
}

