/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.interceptor;

import cn.hamm.airpower.annotation.DesensitizeExclude;
import cn.hamm.airpower.annotation.Filter;
import cn.hamm.airpower.model.Json;
import cn.hamm.airpower.model.query.QueryPageResponse;
import cn.hamm.airpower.root.RootModel;
import cn.hamm.airpower.util.Utils;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class ResponseBodyInterceptor
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LoggerFactory.getLogger(ResponseBodyInterceptor.class);

    @Contract(pure=true)
    public final boolean supports(@NotNull MethodParameter returnType, @NotNull Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    public final Object beforeBodyWrite(Object body, @NotNull MethodParameter returnType, @NotNull MediaType selectedContentType, @NotNull Class<? extends HttpMessageConverter<?>> selectedConverterType, @NotNull ServerHttpRequest request, @NotNull ServerHttpResponse response) {
        Method method = (Method)this.getShareData("REQUEST_METHOD_KEY");
        if (Objects.isNull(method)) {
            return this.beforeResponseFinished(body, request, response);
        }
        return this.beforeResponseFinished(this.getResult(body, method), request, response);
    }

    @Contract(value="null, _ -> null")
    private <M extends RootModel<M>> Object getResult(Object result, Method method) {
        if (!(result instanceof Json)) {
            return result;
        }
        Json json = (Json)result;
        if (Objects.isNull(json.getData())) {
            return result;
        }
        Filter filter = Utils.getReflectUtil().getAnnotation(Filter.class, method);
        DesensitizeExclude desensitizeExclude = Utils.getReflectUtil().getAnnotation(DesensitizeExclude.class, method);
        if (json.getData() instanceof QueryPageResponse) {
            QueryPageResponse queryPageResponse = (QueryPageResponse)json.getData();
            queryPageResponse.getList().forEach(item -> item.filterAndDesensitize(filter, Objects.isNull(desensitizeExclude)));
            return json.setData(queryPageResponse);
        }
        Class<?> dataCls = json.getData().getClass();
        if (json.getData() instanceof Collection) {
            Collection collection = Utils.getCollectionUtil().getCollectWithoutNull((Collection)json.getData(), dataCls);
            collection.stream().toList().forEach(item -> {
                if (Utils.getReflectUtil().isModel(item.getClass())) {
                    ((RootModel)item).filterAndDesensitize(filter, Objects.isNull(desensitizeExclude));
                }
            });
            return json.setData(collection);
        }
        if (Utils.getReflectUtil().isModel(dataCls)) {
            return json.setData(((RootModel)json.getData()).filterAndDesensitize(filter, Objects.isNull(desensitizeExclude)));
        }
        return json;
    }

    protected Object beforeResponseFinished(Object body, ServerHttpRequest request, ServerHttpResponse response) {
        return body;
    }

    @Nullable
    protected final Object getShareData(String key) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (Objects.isNull(requestAttributes)) {
            return null;
        }
        return requestAttributes.getAttribute(key, 0);
    }
}

