/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower;

import cn.hamm.airpower.config.Configs;
import cn.hamm.airpower.config.WebSocketConfig;
import cn.hamm.airpower.exception.ServiceException;
import cn.hamm.airpower.interceptor.AbstractRequestInterceptor;
import cn.hamm.airpower.interceptor.cache.RequestCacheFilter;
import cn.hamm.airpower.resolver.AccessResolver;
import cn.hamm.airpower.websocket.WebSocketHandler;
import cn.hamm.airpower.websocket.WebSocketSupport;
import jakarta.servlet.Filter;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;

@Configuration
public abstract class AbstractWebConfig
implements WebMvcConfigurer,
WebSocketConfigurer {
    @Autowired
    private AccessResolver accessResolver;
    @Autowired
    private WebSocketConfig webSocketConfig;

    @Bean
    public abstract AbstractRequestInterceptor getAccessInterceptor();

    @Bean
    public WebSocketHandler getWebsocketHandler() {
        return new WebSocketHandler();
    }

    public final void addInterceptors(@NotNull InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.getAccessInterceptor()).addPathPatterns(new String[]{"/**"});
        this.addCustomInterceptors(registry);
    }

    public final void addArgumentResolvers(@NotNull List<HandlerMethodArgumentResolver> resolvers) {
        resolvers.add(this.accessResolver);
    }

    public void addCustomInterceptors(InterceptorRegistry registry) {
    }

    @Bean
    public FilterRegistrationBean<RequestCacheFilter> bodyCachingFilterRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new RequestCacheFilter());
        registration.addUrlPatterns(new String[]{"/*"});
        return registration;
    }

    public final void registerWebSocketHandlers(@NotNull WebSocketHandlerRegistry registry) {
        if (Configs.getWebsocketConfig().getSupport().equals((Object)WebSocketSupport.NO)) {
            return;
        }
        String channelPrefix = Configs.getWebsocketConfig().getChannelPrefix();
        if (Objects.isNull(channelPrefix) || !StringUtils.hasText((String)channelPrefix)) {
            throw new ServiceException("\u6ca1\u6709\u914d\u7f6e airpower.websocket.channelPrefix, \u65e0\u6cd5\u542f\u52a8WebSocket\u670d\u52a1");
        }
        registry.addHandler((org.springframework.web.socket.WebSocketHandler)this.getWebsocketHandler(), new String[]{Configs.getWebsocketConfig().getPath()}).setAllowedOrigins(new String[]{this.webSocketConfig.getAllowedOrigins()});
    }
}

