/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.util;

import cn.hamm.airpower.config.PatternConstant;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class ValidateUtil {
    public final boolean isNumber(String value) {
        return this.validRegex(value, PatternConstant.NUMBER);
    }

    public final boolean isInteger(String value) {
        return this.validRegex(value, PatternConstant.INTEGER);
    }

    public final boolean isEmail(String value) {
        return this.validRegex(value, PatternConstant.EMAIL);
    }

    public final boolean isLetter(String value) {
        return this.validRegex(value, PatternConstant.LETTER);
    }

    public final boolean isLetterOrNumber(String value) {
        return this.validRegex(value, PatternConstant.LETTER_OR_NUMBER);
    }

    public final boolean isChinese(String value) {
        return this.validRegex(value, PatternConstant.CHINESE);
    }

    public final boolean isMobilePhone(String value) {
        return this.validRegex(value, PatternConstant.MOBILE_PHONE);
    }

    public final boolean isTelPhone(String value) {
        return this.validRegex(value, PatternConstant.TEL_PHONE);
    }

    public final boolean isNormalCode(String value) {
        return this.validRegex(value, PatternConstant.NORMAL_CODE);
    }

    public final boolean isOnlyNumberAndLetter(String value) {
        return this.validRegex(value, PatternConstant.NUMBER_OR_LETTER);
    }

    public final boolean isNaturalNumber(String value) {
        return this.validRegex(value, PatternConstant.NATURAL_NUMBER);
    }

    public final boolean isNaturalInteger(String value) {
        return this.validRegex(value, PatternConstant.NATURAL_INTEGER);
    }

    public final boolean validRegex(String value, @NotNull Pattern pattern) {
        Matcher emailMatcher = pattern.matcher(value);
        return emailMatcher.matches();
    }
}

