/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.util;

import cn.hamm.airpower.enums.ServiceError;
import cn.hamm.airpower.exception.ServiceException;
import cn.hamm.airpower.model.Json;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class TokenUtil {
    private static final Logger log = LoggerFactory.getLogger(TokenUtil.class);
    private static final String HMAC_SHA_256 = "HmacSHA256";
    private static final String PAYLOADS_IS_EMPTY = "payloads is empty";
    private static final String HMAC_SHA_256_ERROR = "hmacSha256 error";
    private final VerifiedToken verifiedToken = new VerifiedToken();

    public final String create(String secret) {
        ServiceError.PARAM_INVALID.whenEquals("airpower", secret, "\u8eab\u4efd\u4ee4\u724c\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u5728\u73af\u5883\u53d8\u91cf\u914d\u7f6e airpower.accessTokenSecret");
        if (this.verifiedToken.getPayloads().isEmpty()) {
            throw new ServiceException(PAYLOADS_IS_EMPTY);
        }
        String payloadBase = Base64.getUrlEncoder().encodeToString(Json.toString(this.verifiedToken.getPayloads()).getBytes(StandardCharsets.UTF_8));
        String content = this.verifiedToken.getExpireTimestamps() + "." + this.hmacSha256(secret, this.verifiedToken.getExpireTimestamps() + "." + payloadBase) + "." + payloadBase;
        return Base64.getUrlEncoder().encodeToString(content.getBytes(StandardCharsets.UTF_8));
    }

    @Contract(value="_, _ -> this")
    public final TokenUtil addPayload(String key, Object value) {
        this.verifiedToken.getPayloads().put(key, value);
        return this;
    }

    @Contract(value="_ -> this")
    public final TokenUtil removePayload(String key) {
        this.verifiedToken.getPayloads().remove(key);
        return this;
    }

    @Contract(value="_ -> this")
    public final TokenUtil setExpireMillisecond(long millisecond) {
        if (millisecond <= 0L) {
            throw new ServiceException(ServiceError.PARAM_INVALID, "\u8fc7\u671f\u6beb\u79d2\u6570\u5fc5\u987b\u5927\u4e8e0");
        }
        this.verifiedToken.setExpireTimestamps(System.currentTimeMillis() + millisecond);
        return this;
    }

    public final VerifiedToken verify(@NotNull String accessToken, String secret) {
        String source;
        try {
            source = new String(Base64.getUrlDecoder().decode(accessToken.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception exception) {
            throw new ServiceException(ServiceError.UNAUTHORIZED, "\u8eab\u4efd\u4ee4\u724c\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u8eab\u4efd\u4ee4\u724c");
        }
        if (!StringUtils.hasText((String)source)) {
            throw new ServiceException(ServiceError.UNAUTHORIZED, "\u8eab\u4efd\u4ee4\u724c\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u8eab\u4efd\u4ee4\u724c");
        }
        String[] list = source.split("\\.");
        if (list.length != 3) {
            throw new ServiceException(ServiceError.UNAUTHORIZED);
        }
        if (!this.hmacSha256(secret, list[0] + "." + list[2]).equals(list[1])) {
            throw new ServiceException(ServiceError.UNAUTHORIZED, "\u8eab\u4efd\u4ee4\u724c\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u8eab\u4efd\u4ee4\u724c");
        }
        if (Long.parseLong(list[0]) < System.currentTimeMillis() && Long.parseLong(list[0]) != 0L) {
            throw new ServiceException(ServiceError.UNAUTHORIZED, "\u8eab\u4efd\u4ee4\u724c\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u8eab\u4efd\u4ee4\u724c");
        }
        Map<String, Object> payloads = Json.parse2Map(new String(Base64.getUrlDecoder().decode(list[2].getBytes(StandardCharsets.UTF_8))));
        return new VerifiedToken().setExpireTimestamps(Long.parseLong(list[0])).setPayloads(payloads);
    }

    @NotNull
    private String hmacSha256(@NotNull String secret, @NotNull String content) {
        try {
            Mac mac = Mac.getInstance(HMAC_SHA_256);
            SecretKeySpec secretKeySpec = new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), HMAC_SHA_256);
            mac.init(secretKeySpec);
            StringBuilder hexString = new StringBuilder();
            for (byte b : mac.doFinal(content.getBytes(StandardCharsets.UTF_8))) {
                hexString.append(String.format("%02x", b & 0xFF));
            }
            return hexString.toString();
        }
        catch (Exception exception) {
            log.error(HMAC_SHA_256_ERROR, (Throwable)exception);
            throw new ServiceException(HMAC_SHA_256_ERROR);
        }
    }

    public static class VerifiedToken {
        private Map<String, Object> payloads = new HashMap<String, Object>();
        private long expireTimestamps = 0L;

        @Nullable
        public final Object getPayload(String key) {
            return this.payloads.get(key);
        }

        public Map<String, Object> getPayloads() {
            return this.payloads;
        }

        public long getExpireTimestamps() {
            return this.expireTimestamps;
        }

        public VerifiedToken setPayloads(Map<String, Object> payloads) {
            this.payloads = payloads;
            return this;
        }

        public VerifiedToken setExpireTimestamps(long expireTimestamps) {
            this.expireTimestamps = expireTimestamps;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VerifiedToken)) {
                return false;
            }
            VerifiedToken other = (VerifiedToken)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getExpireTimestamps() != other.getExpireTimestamps()) {
                return false;
            }
            Map<String, Object> this$payloads = this.getPayloads();
            Map<String, Object> other$payloads = other.getPayloads();
            return !(this$payloads == null ? other$payloads != null : !((Object)this$payloads).equals(other$payloads));
        }

        protected boolean canEqual(Object other) {
            return other instanceof VerifiedToken;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $expireTimestamps = this.getExpireTimestamps();
            result = result * 59 + (int)($expireTimestamps >>> 32 ^ $expireTimestamps);
            Map<String, Object> $payloads = this.getPayloads();
            result = result * 59 + ($payloads == null ? 43 : ((Object)$payloads).hashCode());
            return result;
        }

        public String toString() {
            return "TokenUtil.VerifiedToken(payloads=" + this.getPayloads() + ", expireTimestamps=" + this.getExpireTimestamps() + ")";
        }
    }
}

