/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class NumberUtil {
    private static final int DEFAULT_SCALE = 8;
    private static final RoundingMode DEFAULT_ROUNDING_MODE = RoundingMode.HALF_UP;

    public final double add(double first, double second, double ... values) {
        return ((BigDecimal)this.calc(BigDecimal::add, BigDecimal.valueOf(first), BigDecimal.valueOf(second), (BigDecimal[])Arrays.stream(values).mapToObj(BigDecimal::valueOf).toArray(BigDecimal[]::new))).doubleValue();
    }

    public final long add(long first, long second, long ... values) {
        return ((BigInteger)this.calc(BigInteger::add, BigInteger.valueOf(first), BigInteger.valueOf(second), (BigInteger[])Arrays.stream(values).mapToObj(BigInteger::valueOf).toArray(BigInteger[]::new))).longValue();
    }

    public final double sub(double first, double second, double ... values) {
        return ((BigDecimal)this.calc(BigDecimal::subtract, BigDecimal.valueOf(first), BigDecimal.valueOf(second), (BigDecimal[])Arrays.stream(values).mapToObj(BigDecimal::valueOf).toArray(BigDecimal[]::new))).doubleValue();
    }

    public final long sub(long first, long second, long ... values) {
        return ((BigInteger)this.calc(BigInteger::subtract, BigInteger.valueOf(first), BigInteger.valueOf(second), (BigInteger[])Arrays.stream(values).mapToObj(BigInteger::valueOf).toArray(BigInteger[]::new))).longValue();
    }

    public final double mul(double first, double second, double ... values) {
        return ((BigDecimal)this.calc(BigDecimal::multiply, BigDecimal.valueOf(first), BigDecimal.valueOf(second), (BigDecimal[])Arrays.stream(values).mapToObj(BigDecimal::valueOf).toArray(BigDecimal[]::new))).doubleValue();
    }

    public final long mul(long first, long second, long ... values) {
        return ((BigInteger)this.calc(BigInteger::multiply, BigInteger.valueOf(first), BigInteger.valueOf(second), (BigInteger[])Arrays.stream(values).mapToObj(BigInteger::valueOf).toArray(BigInteger[]::new))).longValue();
    }

    private <T extends Number> T calc(@NotNull BiFunction<T, T, T> function, T first, T second, T[] values) {
        Number result = (Number)function.apply(first, second);
        if (Objects.nonNull(values)) {
            for (T value : values) {
                result = (Number)function.apply(result, (Number)value);
            }
        }
        return (T)result;
    }

    public final double div(double first, double second, double ... values) {
        return this.div(BigDecimal.valueOf(first), BigDecimal.valueOf(second), (BigDecimal[])Arrays.stream(values).mapToObj(BigDecimal::valueOf).toArray(BigDecimal[]::new)).doubleValue();
    }

    public final double div(long first, long second, long ... values) {
        return this.div(BigDecimal.valueOf(first), BigDecimal.valueOf(second), (BigDecimal[])Arrays.stream(values).mapToObj(BigDecimal::valueOf).toArray(BigDecimal[]::new)).doubleValue();
    }

    private BigDecimal div(BigDecimal first, BigDecimal second, BigDecimal[] values) {
        try {
            BigDecimal result = first.divide(second, 8, DEFAULT_ROUNDING_MODE);
            if (Objects.nonNull(values)) {
                for (BigDecimal value : values) {
                    result = result.divide(value, 8, DEFAULT_ROUNDING_MODE);
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("\u8ba1\u7b97\u51fa\u73b0\u5f02\u5e38");
        }
    }

    @NotNull
    public final BigDecimal floor(double value, int scale) {
        return this.round(value, scale, RoundingMode.DOWN);
    }

    @NotNull
    public final BigDecimal ceil(double value, int scale) {
        return this.round(value, scale, RoundingMode.UP);
    }

    @NotNull
    public final BigDecimal round(double number, int scale, @NotNull RoundingMode roundingMode) {
        if (scale < 0) {
            scale = 0;
        }
        return BigDecimal.valueOf(number).setScale(scale, roundingMode);
    }
}

