/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.util;

import cn.hamm.airpower.config.Configs;
import java.util.UUID;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MqttUtil {
    private static final Logger log = LoggerFactory.getLogger(MqttUtil.class);

    @NotNull
    public MqttClient createClient() throws MqttException {
        return this.createClient(UUID.randomUUID().toString());
    }

    @NotNull
    public MqttClient createClient(String id) throws MqttException {
        return new MqttClient("tcp://" + Configs.getMqttConfig().getHost() + ":" + Configs.getMqttConfig().getPort(), id, (MqttClientPersistence)new MemoryPersistence());
    }

    public MqttConnectOptions createOption() {
        MqttConnectOptions options = new MqttConnectOptions();
        options.setCleanSession(false);
        options.setUserName(Configs.getMqttConfig().getUser());
        options.setPassword(Configs.getMqttConfig().getPass().toCharArray());
        options.setConnectionTimeout(30);
        options.setKeepAliveInterval(10);
        return options;
    }

    public void publish(@NotNull String topic, @NotNull String message) throws MqttException {
        MqttClient client = this.createClient();
        client.connect(this.createOption());
        MqttMessage mqttMessage = new MqttMessage();
        mqttMessage.setPayload(message.getBytes());
        mqttMessage.setQos(0);
        MqttTopic mqttTopic = client.getTopic(topic);
        try {
            MqttDeliveryToken token = mqttTopic.publish(mqttMessage);
            token.waitForCompletion();
            client.disconnect();
            client.close();
        }
        catch (MqttException exception) {
            log.error("MQTT\u53d1\u5e03\u5931\u8d25", (Throwable)exception);
        }
    }
}

