/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.util;

import cn.hamm.airpower.enums.ContentType;
import cn.hamm.airpower.enums.HttpMethod;
import cn.hamm.airpower.exception.ServiceException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Contract;

public class HttpUtil {
    private Map<String, Object> headers = new HashMap<String, Object>();
    private Map<String, Object> cookies = new HashMap<String, Object>();
    private String url;
    private String body = "";
    private HttpMethod method = HttpMethod.GET;
    private ContentType contentType = ContentType.JSON;
    private int connectTimeout = 5;

    @Contract(value="_, _ -> this")
    public final HttpUtil addCookie(String key, String value) {
        this.cookies.put(key, value);
        return this;
    }

    public final HttpResponse<String> post() {
        this.method = HttpMethod.POST;
        return this.send();
    }

    public final HttpResponse<String> post(String body) {
        this.method = HttpMethod.POST;
        this.body = body;
        return this.send();
    }

    public final HttpResponse<String> get() {
        this.method = HttpMethod.GET;
        return this.send();
    }

    public final HttpResponse<String> send() {
        try {
            return this.getHttpClient().send(this.getHttpRequest(), HttpResponse.BodyHandlers.ofString());
        }
        catch (Exception exception) {
            throw new ServiceException(exception);
        }
    }

    private HttpRequest getHttpRequest() {
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(this.url));
        this.headers.forEach((key, value) -> requestBuilder.header((String)key, value.toString()));
        HttpRequest.BodyPublisher bodyPublisher = HttpRequest.BodyPublishers.ofString(this.body);
        switch (this.method) {
            case GET: {
                requestBuilder.GET();
                break;
            }
            case POST: {
                requestBuilder.POST(bodyPublisher);
                break;
            }
            case PUT: {
                requestBuilder.PUT(bodyPublisher);
                break;
            }
            case DELETE: {
                requestBuilder.DELETE();
                break;
            }
        }
        if (Objects.nonNull(this.cookies)) {
            ArrayList cookieList = new ArrayList();
            this.cookies.forEach((key, value) -> cookieList.add(key + "=" + value));
            requestBuilder.setHeader("Cookie", String.join((CharSequence)"; ", cookieList));
        }
        if (Objects.nonNull((Object)this.contentType)) {
            requestBuilder.header("Content-Type", this.contentType.getValue());
        }
        return requestBuilder.build();
    }

    private HttpClient getHttpClient() {
        HttpClient.Builder httpClientBuilder = HttpClient.newBuilder();
        if (this.connectTimeout > 0) {
            httpClientBuilder.connectTimeout(Duration.ofSeconds(this.connectTimeout));
        }
        return httpClientBuilder.build();
    }

    @Contract(value="_, _ -> this")
    public final HttpUtil addHeader(String key, Object value) {
        this.headers.put(key, value);
        return this;
    }

    public final Map<String, Object> getHeaders() {
        return this.headers;
    }

    public final Map<String, Object> getCookies() {
        return this.cookies;
    }

    public final String getUrl() {
        return this.url;
    }

    public final String getBody() {
        return this.body;
    }

    public final HttpMethod getMethod() {
        return this.method;
    }

    public final ContentType getContentType() {
        return this.contentType;
    }

    public final int getConnectTimeout() {
        return this.connectTimeout;
    }

    public final HttpUtil setHeaders(Map<String, Object> headers) {
        this.headers = headers;
        return this;
    }

    public final HttpUtil setCookies(Map<String, Object> cookies) {
        this.cookies = cookies;
        return this;
    }

    public final HttpUtil setUrl(String url) {
        this.url = url;
        return this;
    }

    public final HttpUtil setBody(String body) {
        this.body = body;
        return this;
    }

    public final HttpUtil setMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    public final HttpUtil setContentType(ContentType contentType) {
        this.contentType = contentType;
        return this;
    }

    public final HttpUtil setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpUtil)) {
            return false;
        }
        HttpUtil other = (HttpUtil)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getConnectTimeout() != other.getConnectTimeout()) {
            return false;
        }
        Map<String, Object> this$headers = this.getHeaders();
        Map<String, Object> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        Map<String, Object> this$cookies = this.getCookies();
        Map<String, Object> other$cookies = other.getCookies();
        if (this$cookies == null ? other$cookies != null : !((Object)this$cookies).equals(other$cookies)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        HttpMethod this$method = this.getMethod();
        HttpMethod other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
            return false;
        }
        ContentType this$contentType = this.getContentType();
        ContentType other$contentType = other.getContentType();
        return !(this$contentType == null ? other$contentType != null : !((Object)((Object)this$contentType)).equals((Object)other$contentType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpUtil;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getConnectTimeout();
        Map<String, Object> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        Map<String, Object> $cookies = this.getCookies();
        result = result * 59 + ($cookies == null ? 43 : ((Object)$cookies).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        HttpMethod $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
        ContentType $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : ((Object)((Object)$contentType)).hashCode());
        return result;
    }

    public String toString() {
        return "HttpUtil(headers=" + this.getHeaders() + ", cookies=" + this.getCookies() + ", url=" + this.getUrl() + ", body=" + this.getBody() + ", method=" + this.getMethod() + ", contentType=" + this.getContentType() + ", connectTimeout=" + this.getConnectTimeout() + ")";
    }
}

