/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.util;

import cn.hamm.airpower.enums.ServiceError;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;

@Component
public class EmailUtil {
    @Autowired(required=false)
    private JavaMailSender javaMailSender;
    @Value(value="${spring.mail.username: ''}")
    private String mailFrom;

    public final void sendCode(@NotNull String email, @NotNull String title, @NotNull String code, @NotNull String sign) throws MessagingException {
        String content = "<div style='border-radius:20px;padding: 20px;background-color:#f5f5f5;color:#333;display:inline-block;'>\n<div style='font-size:24px;font-weight:bold;color:orangered;'>\n" + code + "</div>\n<div style='margin-top:20px;font-size:16px;font-weight:300'>\n    \u4e0a\u9762\u662f\u4f60\u7684\u9a8c\u8bc1\u7801\uff0c\u8bf7\u6ce8\u610f\u4e0d\u8981\u8f6c\u53d1\u7ed9\u4ed6\u4eba\uff0c\u4e94\u5206\u949f\u5185\u6709\u6548\uff0c\u8bf7\u5c3d\u5feb\u4f7f\u7528\u3002\n</div>\n<div style='margin-top:10px;font-size:12px;color:#aaa;font-weight:300'>\n" + sign + "</div></div>\n";
        this.sendEmail(email, title, content);
    }

    public final void sendEmail(@NotNull String email, @NotNull String title, @NotNull String content) throws MessagingException {
        ServiceError.EMAIL_ERROR.whenNull(this.javaMailSender, "\u672a\u914d\u7f6e\u90ae\u4ef6\u670d\u52a1\u7684\u4fe1\u606f");
        MimeMessage message = this.javaMailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        helper.setTo(email);
        helper.setSubject(title);
        helper.setFrom(this.mailFrom);
        helper.setText(content, true);
        this.javaMailSender.send(message);
    }
}

