/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.util;

import cn.hamm.airpower.interfaces.IDictionary;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class DictionaryUtil {
    private static final Logger log = LoggerFactory.getLogger(DictionaryUtil.class);

    @Nullable
    public final <D extends IDictionary> D getDictionaryByKey(@NotNull Class<D> enumClass, int key) {
        try {
            D[] objs;
            Method getKey = enumClass.getMethod("getKey", new Class[0]);
            for (D obj : objs = enumClass.getEnumConstants()) {
                int exitValue = (Integer)getKey.invoke(obj, new Object[0]);
                if (exitValue != key) continue;
                return (D)((IDictionary)obj);
            }
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
        }
        return null;
    }

    @NotNull
    public final <D extends IDictionary> List<Map<String, String>> getDictionaryList(@NotNull Class<D> clazz) {
        return this.getDictionaryList(clazz, "key", "label");
    }

    @NotNull
    public final <D extends IDictionary> List<Map<String, String>> getDictionaryList(@NotNull Class<D> clazz, String ... params) {
        ArrayList<Map<String, String>> mapList = new ArrayList<Map<String, String>>();
        for (IDictionary obj : (IDictionary[])clazz.getEnumConstants()) {
            HashMap<String, String> item = new HashMap<String, String>(params.length);
            for (String param : params) {
                try {
                    Method method = clazz.getMethod("get" + StringUtils.capitalize((String)param), new Class[0]);
                    item.put(param, method.invoke((Object)obj, new Object[0]).toString());
                }
                catch (Exception exception) {
                    log.error(exception.getMessage(), (Throwable)exception);
                }
            }
            mapList.add(item);
        }
        return mapList;
    }
}

