/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.root;

import cn.hamm.airpower.annotation.Exclude;
import cn.hamm.airpower.annotation.Expose;
import cn.hamm.airpower.annotation.Payload;
import cn.hamm.airpower.exception.ServiceException;
import cn.hamm.airpower.interfaces.IAction;
import cn.hamm.airpower.util.Utils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class RootModel<M extends RootModel<M>>
implements IAction {
    private static final Logger log = LoggerFactory.getLogger(RootModel.class);

    @NotNull
    public final M copy() {
        try {
            RootModel target = (RootModel)this.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            BeanUtils.copyProperties((Object)this, (Object)target);
            return (M)target;
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            throw new ServiceException(exception);
        }
    }

    public final M filterResponseDataBy(@NotNull Class<?> filter) {
        Class<?> clazz = this.getClass();
        List<Field> allFields = Utils.getReflectUtil().getFieldList(clazz);
        Exclude exclude = clazz.getAnnotation(Exclude.class);
        BiConsumer<Class, Field> task = Objects.nonNull(exclude) ? this::exposeBy : this::excludeBy;
        allFields.forEach(field -> task.accept(filter, (Field)field));
        return (M)this;
    }

    private void excludeBy(@NotNull Class<?> filter, @NotNull Field field) {
        Exclude fieldExclude = Utils.getReflectUtil().getAnnotation(Exclude.class, field);
        if (Objects.isNull(fieldExclude)) {
            this.filterFieldPayload(field);
            return;
        }
        Class<?>[] excludeClasses = fieldExclude.filters();
        boolean isNeedClear = true;
        if (excludeClasses.length > 0) {
            isNeedClear = Arrays.asList(excludeClasses).contains(filter);
        }
        if (isNeedClear) {
            Utils.getReflectUtil().clearFieldValue(this, field);
        }
        this.filterFieldPayload(field);
    }

    private void exposeBy(@NotNull Class<?> filter, @NotNull Field field) {
        boolean isExpose;
        Expose fieldExpose = Utils.getReflectUtil().getAnnotation(Expose.class, field);
        if (Objects.isNull(fieldExpose)) {
            Utils.getReflectUtil().clearFieldValue(this, field);
            this.filterFieldPayload(field);
            return;
        }
        Class<?>[] exposeClasses = fieldExpose.filters();
        if (exposeClasses.length > 0 && !(isExpose = Arrays.asList(exposeClasses).contains(filter))) {
            Utils.getReflectUtil().clearFieldValue(this, field);
        }
        this.filterFieldPayload(field);
    }

    private void filterFieldPayload(@NotNull Field field) {
        Payload payload = Utils.getReflectUtil().getAnnotation(Payload.class, field);
        if (Objects.isNull(payload)) {
            return;
        }
        Object fieldValue = Utils.getReflectUtil().getFieldValue(this, field);
        if (fieldValue instanceof Collection) {
            Class<?> fieldClass = field.getType();
            Collection<RootModel> collection = Utils.getCollectionUtil().getCollectWithoutNull((Collection)fieldValue, fieldClass);
            collection.forEach(item -> item.filterResponseDataBy(IAction.WhenPayLoad.class));
            Utils.getReflectUtil().setFieldValue(this, field, collection);
            return;
        }
        if (Objects.nonNull(fieldValue)) {
            Utils.getReflectUtil().setFieldValue(this, field, ((RootModel)fieldValue).filterResponseDataBy(IAction.WhenPayLoad.class));
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RootModel)) {
            return false;
        }
        RootModel other = (RootModel)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof RootModel;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

