/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.root;

import cn.hamm.airpower.annotation.Description;
import cn.hamm.airpower.annotation.Extends;
import cn.hamm.airpower.annotation.Filter;
import cn.hamm.airpower.annotation.Permission;
import cn.hamm.airpower.enums.Api;
import cn.hamm.airpower.enums.ServiceError;
import cn.hamm.airpower.exception.ServiceException;
import cn.hamm.airpower.interfaces.IEntityAction;
import cn.hamm.airpower.model.Json;
import cn.hamm.airpower.model.query.QueryPageRequest;
import cn.hamm.airpower.model.query.QueryPageResponse;
import cn.hamm.airpower.model.query.QueryRequest;
import cn.hamm.airpower.root.RootController;
import cn.hamm.airpower.root.RootEntity;
import cn.hamm.airpower.root.RootRepository;
import cn.hamm.airpower.root.RootService;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Permission
public class RootEntityController<E extends RootEntity<E>, S extends RootService<E, R>, R extends RootRepository<E>>
extends RootController
implements IEntityAction {
    @Autowired
    protected S service;

    @Description(value="\u6dfb\u52a0")
    @RequestMapping(value={"add"})
    @Filter(value=IEntityAction.WhenGetDetail.class)
    public Json add(@RequestBody @Validated(value={IEntityAction.WhenAdd.class}) E entity) {
        this.checkApiAvailableStatus(Api.Add);
        ((RootService)this.service).ignoreReadOnlyFields(entity);
        long insertId = ((RootService)this.service).add(this.beforeAdd(entity));
        this.execute(() -> this.afterAdd(insertId, entity), () -> this.afterSaved(insertId, entity));
        return Json.entity(insertId, "\u6dfb\u52a0\u6210\u529f");
    }

    @Description(value="\u4fee\u6539")
    @RequestMapping(value={"update"})
    @Filter(value=IEntityAction.WhenGetDetail.class)
    public Json update(@RequestBody @Validated(value={IEntityAction.WhenUpdate.class}) @NotNull E entity) {
        this.checkApiAvailableStatus(Api.Update);
        long updateId = ((RootEntity)entity).getId();
        ((RootService)this.service).update(this.beforeUpdate(((RootService)this.service).ignoreReadOnlyFields(entity)));
        this.execute(() -> this.afterUpdate(updateId, entity), () -> this.afterSaved(updateId, entity));
        return Json.entity(updateId, "\u4fee\u6539\u6210\u529f");
    }

    @Description(value="\u5220\u9664")
    @RequestMapping(value={"delete"})
    public Json delete(@RequestBody @Validated(value={IEntityAction.WhenIdRequired.class}) @NotNull E entity) {
        this.checkApiAvailableStatus(Api.Delete);
        long deleteId = ((RootEntity)entity).getId();
        this.beforeDelete(deleteId);
        ((RootService)this.service).delete(deleteId);
        this.execute(() -> this.afterDelete(deleteId), new Runnable[0]);
        return Json.entity(deleteId, "\u5220\u9664\u6210\u529f");
    }

    @Description(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"getDetail"})
    @Filter(value=IEntityAction.WhenGetDetail.class)
    public Json getDetail(@RequestBody @Validated(value={IEntityAction.WhenIdRequired.class}) @NotNull E entity) {
        this.checkApiAvailableStatus(Api.GetDetail);
        return Json.data(this.afterGetDetail(((RootService)this.service).get(((RootEntity)entity).getId())));
    }

    @Description(value="\u7981\u7528")
    @RequestMapping(value={"disable"})
    public Json disable(@RequestBody @Validated(value={IEntityAction.WhenIdRequired.class}) @NotNull E entity) {
        this.checkApiAvailableStatus(Api.Disable);
        this.beforeDisable(((RootEntity)entity).getId());
        ((RootService)this.service).disable(((RootEntity)entity).getId());
        this.execute(() -> this.afterDisable(entity.getId()), new Runnable[0]);
        return Json.entity(((RootEntity)entity).getId(), "\u7981\u7528\u6210\u529f");
    }

    @Description(value="\u542f\u7528")
    @RequestMapping(value={"enable"})
    public Json enable(@RequestBody @Validated(value={IEntityAction.WhenIdRequired.class}) @NotNull E entity) {
        this.checkApiAvailableStatus(Api.Enable);
        this.beforeEnable(((RootEntity)entity).getId());
        ((RootService)this.service).enable(((RootEntity)entity).getId());
        this.execute(() -> this.afterEnable(entity.getId()), new Runnable[0]);
        return Json.entity(((RootEntity)entity).getId(), "\u542f\u7528\u6210\u529f");
    }

    @Description(value="\u4e0d\u5206\u9875\u67e5\u8be2")
    @RequestMapping(value={"getList"})
    @Filter(value=IEntityAction.WhenGetList.class)
    public Json getList(@RequestBody QueryRequest<E> queryRequest) {
        queryRequest = this.getQueryRequest(queryRequest);
        this.checkApiAvailableStatus(Api.GetList);
        return Json.data(this.afterGetList(((RootService)this.service).getList(this.beforeGetList(queryRequest))));
    }

    @Description(value="\u5206\u9875\u67e5\u8be2")
    @RequestMapping(value={"getPage"})
    @Filter(value=IEntityAction.WhenGetPage.class)
    public Json getPage(@RequestBody QueryPageRequest<E> queryPageRequest) {
        queryPageRequest = this.getQueryRequest(queryPageRequest);
        this.checkApiAvailableStatus(Api.GetPage);
        return Json.data(this.afterGetPage(((RootService)this.service).getPage(this.beforeGetPage(queryPageRequest))));
    }

    protected <T extends QueryPageResponse<E>> T afterGetPage(T queryPageResponse) {
        return queryPageResponse;
    }

    protected <T extends QueryPageRequest<E>> T beforeGetPage(T queryPageRequest) {
        return queryPageRequest;
    }

    protected <T extends QueryRequest<E>> T beforeGetList(T queryRequest) {
        return queryRequest;
    }

    protected List<E> afterGetList(List<E> list) {
        return list;
    }

    protected E afterGetDetail(E entity) {
        return entity;
    }

    protected E beforeAdd(E entity) {
        return entity;
    }

    protected void afterAdd(long id, E source) {
    }

    protected E beforeUpdate(E entity) {
        return entity;
    }

    protected void afterUpdate(long id, E source) {
    }

    protected void afterSaved(long id, E source) {
    }

    protected void beforeDelete(long id) {
    }

    protected void afterDelete(long id) {
    }

    protected void beforeDisable(long id) {
    }

    protected void afterDisable(long id) {
    }

    protected void beforeEnable(long id) {
    }

    protected void afterEnable(long id) {
    }

    @NotNull
    private <T extends QueryRequest<E>> T getQueryRequest(T queryRequest) {
        queryRequest = Objects.requireNonNullElse(queryRequest, new QueryRequest());
        ((QueryRequest)queryRequest).setFilter(Objects.requireNonNullElse((RootEntity)((QueryRequest)queryRequest).getFilter(), this.getNewInstance()));
        return (T)queryRequest;
    }

    private void checkApiAvailableStatus(Api api) {
        Extends extendsApi = this.getClass().getAnnotation(Extends.class);
        if (Objects.isNull(extendsApi)) {
            return;
        }
        if (extendsApi.value().length == 0 && extendsApi.exclude().length == 0) {
            return;
        }
        if (extendsApi.value().length > 0 && Arrays.asList(extendsApi.value()).contains(api)) {
            return;
        }
        if (extendsApi.exclude().length > 0 && !Arrays.asList(extendsApi.exclude()).contains(api)) {
            return;
        }
        ServiceError.API_SERVICE_UNSUPPORTED.show();
    }

    @NotNull
    private E getNewInstance() {
        try {
            return (E)((RootEntity)this.getEntityClass().getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception exception) {
            throw new ServiceException(exception.getMessage());
        }
    }

    private Class<E> getEntityClass() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }
}

