/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.model;

import cn.hamm.airpower.annotation.Description;
import cn.hamm.airpower.config.Constant;
import cn.hamm.airpower.enums.ServiceError;
import cn.hamm.airpower.exception.ServiceException;
import cn.hamm.airpower.interfaces.IException;
import cn.hamm.airpower.root.RootEntity;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Json {
    private static final Logger log = LoggerFactory.getLogger(Json.class);
    private static ObjectMapper objectMapper = null;
    @Description(value="\u9519\u8bef\u4ee3\u7801")
    private int code = Constant.JSON_SUCCESS_CODE;
    @Description(value="\u9519\u8bef\u4fe1\u606f")
    private String message = "\u64cd\u4f5c\u6210\u529f";
    @Description(value="\u8fd4\u56de\u6570\u636e")
    private Object data;

    @Contract(pure=true)
    private Json() {
    }

    public static Json success(String message) {
        return Json.newJson().setMessage(message);
    }

    public static Json data(Object data) {
        return Json.data(data, "\u83b7\u53d6\u6210\u529f");
    }

    public static <E extends RootEntity<E>> Json entity(@NotNull Long id) {
        return Json.data(new RootEntity().setId(id));
    }

    public static Json entity(@NotNull Long id, @NotNull String message) {
        return Json.entity(id).setMessage(message);
    }

    public static Json data(Object data, String message) {
        return Json.newJson().setData(data).setMessage(message);
    }

    public static Json error(IException error) {
        return Json.error(error, error.getMessage());
    }

    public static Json error(@NotNull IException error, String message) {
        return Json.show(error.getCode(), message, null);
    }

    public static Json error(String message) {
        return Json.error(ServiceError.SERVICE_ERROR, message);
    }

    public static Json show(int code, String message, Object data) {
        return Json.newJson().setCode(code).setMessage(message).setData(data);
    }

    public static <E> E parse(String json, Class<E> clazz) {
        try {
            return (E)Json.getObjectMapper().readValue(json, clazz);
        }
        catch (JsonProcessingException exception) {
            log.error("JSON\u5b57\u7b26\u4e32\u8f6c\u5bf9\u8c61\u5931\u8d25", (Throwable)exception);
            throw new ServiceException((Exception)((Object)exception));
        }
    }

    public static Map<String, Object> parse2Map(String json) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            TypeReference<Map<String, Object>> typeRef = new TypeReference<Map<String, Object>>(){};
            return (Map)objectMapper.readValue(json, (TypeReference)typeRef);
        }
        catch (Exception exception) {
            log.error(exception.getMessage());
            throw new ServiceException(exception);
        }
    }

    public static List<Map<String, Object>> parse2MapList(String json) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            TypeReference<List<Map<String, Object>>> typeRef = new TypeReference<List<Map<String, Object>>>(){};
            return (List)objectMapper.readValue(json, (TypeReference)typeRef);
        }
        catch (Exception exception) {
            log.error(exception.getMessage());
            throw new ServiceException(exception);
        }
    }

    public static String toString(Object object) {
        try {
            return Json.getObjectMapper().writeValueAsString(object);
        }
        catch (JsonProcessingException exception) {
            log.error("\u5bf9\u8c61\u8f6cJSON\u5b57\u7b26\u4e32\u5931\u8d25", (Throwable)exception);
            return "";
        }
    }

    @NotNull
    private static ObjectMapper getObjectMapper() {
        if (Objects.isNull(objectMapper)) {
            objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }
        return objectMapper;
    }

    @Contract(value=" -> new")
    @NotNull
    private static Json newJson() {
        return new Json();
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public Object getData() {
        return this.data;
    }

    public Json setCode(int code) {
        this.code = code;
        return this;
    }

    public Json setMessage(String message) {
        this.message = message;
        return this;
    }

    public Json setData(Object data) {
        this.data = data;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Json)) {
            return false;
        }
        Json other = (Json)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Object this$data = this.getData();
        Object other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Json;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Object $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "Json(code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
    }
}

