/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.interfaces;

import cn.hamm.airpower.exception.ServiceException;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface IException {
    public int getCode();

    public String getMessage();

    @Contract(value=" -> new")
    @NotNull
    private ServiceException create() {
        return new ServiceException(this.getCode(), this.getMessage());
    }

    default public void show() {
        this.show(this.getMessage());
    }

    default public void show(String message) {
        this.show(message, null);
    }

    default public void show(String message, Object data) {
        throw this.create().setMessage(message).setData(data);
    }

    default public void when(boolean condition) {
        this.when(condition, this.getMessage());
    }

    default public void when(boolean condition, String message) {
        if (condition) {
            this.show(message);
        }
    }

    default public void when(boolean condition, String message, Object data) {
        if (condition) {
            this.show(message, data);
        }
    }

    @Contract(value="null -> fail")
    default public void whenNull(Object obj) {
        this.whenNull(obj, this.getMessage());
    }

    @Contract(value="null, _ -> fail")
    default public void whenNull(Object obj, String message) {
        this.when(Objects.isNull(obj), message);
    }

    default public void whenEquals(Object obj1, Object obj2) {
        this.whenEquals(obj1, obj2, this.getMessage());
    }

    default public void whenEquals(@NotNull Object obj1, Object obj2, String message) {
        this.when(obj1.equals(obj2), message);
    }

    default public void whenEquals(String str1, String str2) {
        this.whenEquals(str1, str2, this.getMessage());
    }

    default public void whenEquals(@NotNull String str1, String str2, String message) {
        this.when(str1.equals(str2), message);
    }

    default public void whenEqualsIgnoreCase(String str1, String str2) {
        this.whenEqualsIgnoreCase(str1, str2, this.getMessage());
    }

    default public void whenEqualsIgnoreCase(@NotNull String str1, String str2, String message) {
        this.when(str1.equalsIgnoreCase(str2), message);
    }

    default public void whenNotEquals(Object obj1, Object obj2) {
        this.whenNotEquals(obj1, obj2, this.getMessage());
    }

    default public void whenNotEquals(@NotNull Object obj1, Object obj2, String message) {
        this.when(!obj1.equals(obj2), message);
    }

    default public void whenNotEquals(String str1, String str2) {
        this.whenNotEquals(str1, str2, this.getMessage());
    }

    default public void whenNotEquals(@NotNull String str1, String str2, String message) {
        this.when(!str1.equals(str2), message);
    }

    default public void whenNotEqualsIgnoreCase(String str1, String str2) {
        this.whenNotEqualsIgnoreCase(str1, str2, this.getMessage());
    }

    default public void whenNotEqualsIgnoreCase(@NotNull String str1, String str2, String message) {
        this.when(!str1.equalsIgnoreCase(str2), message);
    }

    default public void whenEmpty(Object obj) {
        this.whenEmpty(obj, this.getMessage());
    }

    default public void whenEmpty(Object obj, String message) {
        this.when(Objects.isNull(obj) || "".equalsIgnoreCase(obj.toString()), message);
    }

    default public void whenNotNull(Object obj) {
        this.whenNotNull(obj, this.getMessage());
    }

    default public void whenNotNull(Object obj, String message) {
        this.when(!Objects.isNull(obj), message);
    }
}

