/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.interceptor;

import cn.hamm.airpower.annotation.Filter;
import cn.hamm.airpower.model.Json;
import cn.hamm.airpower.model.query.QueryPageResponse;
import cn.hamm.airpower.root.RootModel;
import cn.hamm.airpower.util.Utils;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class ResponseBodyInterceptor
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LoggerFactory.getLogger(ResponseBodyInterceptor.class);

    @Contract(pure=true)
    public final boolean supports(@NotNull MethodParameter returnType, @NotNull Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    public final Object beforeBodyWrite(Object body, @NotNull MethodParameter returnType, @NotNull MediaType selectedContentType, @NotNull Class<? extends HttpMessageConverter<?>> selectedConverterType, @NotNull ServerHttpRequest request, @NotNull ServerHttpResponse response) {
        Method method = (Method)this.getShareData("REQUEST_METHOD_KEY");
        if (Objects.isNull(method)) {
            return this.beforeResponseFinished(body, request, response);
        }
        return this.beforeResponseFinished(this.getResult(body, method), request, response);
    }

    @Contract(value="null, _ -> null")
    private <M extends RootModel<M>> Object getResult(Object result, Method method) {
        if (!(result instanceof Json)) {
            return result;
        }
        Json json = (Json)result;
        if (Objects.isNull(json.getData())) {
            return result;
        }
        Filter filter = Utils.getReflectUtil().getAnnotation(Filter.class, method);
        if (Objects.isNull(filter)) {
            return result;
        }
        if (Void.class.equals(filter.value())) {
            return result;
        }
        if (json.getData() instanceof QueryPageResponse) {
            QueryPageResponse queryPageResponse = (QueryPageResponse)json.getData();
            this.filterResponseListBy(filter, queryPageResponse.getList());
            return json.setData(queryPageResponse);
        }
        Class<?> dataCls = json.getData().getClass();
        if (json.getData() instanceof Collection) {
            Collection collection = Utils.getCollectionUtil().getCollectWithoutNull((Collection)json.getData(), dataCls);
            return json.setData(this.filterResponseListBy(filter, collection.stream().toList()));
        }
        if (Utils.getReflectUtil().isModel(dataCls)) {
            return json.setData(this.filterResponseBy(filter, (RootModel)json.getData()));
        }
        return json;
    }

    protected Object beforeResponseFinished(Object body, ServerHttpRequest request, ServerHttpResponse response) {
        return body;
    }

    @Nullable
    protected final Object getShareData(String key) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (Objects.isNull(requestAttributes)) {
            return null;
        }
        return requestAttributes.getAttribute(key, 0);
    }

    private <M extends RootModel<M>> M filterResponseBy(@NotNull Filter filter, @NotNull M data) {
        return data.filterResponseDataBy(filter.value());
    }

    @Contract(value="_, _ -> param2")
    private <M extends RootModel<M>> List<M> filterResponseListBy(@NotNull Filter filter, List<M> list) {
        try {
            list.forEach(item -> this.filterResponseBy(filter, item));
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
        }
        return list;
    }
}

