/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.interceptor;

import cn.hamm.airpower.config.Configs;
import cn.hamm.airpower.enums.ServiceError;
import cn.hamm.airpower.exception.ServiceException;
import cn.hamm.airpower.interceptor.document.ApiDocument;
import cn.hamm.airpower.model.Json;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.servlet.NoHandlerFoundException;

@ControllerAdvice
@ResponseStatus(value=HttpStatus.OK)
@ResponseBody
public class ExceptionInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ExceptionInterceptor.class);

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Json badRequestHandle(@NotNull MethodArgumentNotValidException exception) {
        StringBuilder stringBuilder;
        block2: {
            log.error(exception.getMessage());
            BindingResult result = exception.getBindingResult();
            stringBuilder = new StringBuilder();
            if (!result.hasErrors()) {
                return Json.error(ServiceError.PARAM_INVALID);
            }
            if (!result.hasFieldErrors()) {
                return Json.error(ServiceError.PARAM_INVALID);
            }
            List errors = result.getFieldErrors();
            Iterator iterator = errors.iterator();
            if (!iterator.hasNext()) break block2;
            FieldError error = (FieldError)iterator.next();
            stringBuilder.append(String.format("%s (%s)", error.getDefaultMessage(), error.getField()));
        }
        return Json.error(ServiceError.PARAM_INVALID, stringBuilder.toString());
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public Json badRequestHandle(@NotNull ConstraintViolationException exception) {
        StringBuilder stringBuilder;
        block0: {
            log.error(exception.getMessage());
            stringBuilder = new StringBuilder();
            Set errors = exception.getConstraintViolations();
            Iterator iterator = errors.iterator();
            if (!iterator.hasNext()) break block0;
            ConstraintViolation error = (ConstraintViolation)iterator.next();
            stringBuilder.append(String.format("%s (%s)", error.getMessage(), error.getInvalidValue().toString()));
        }
        return Json.error(ServiceError.PARAM_INVALID, stringBuilder.toString());
    }

    @ExceptionHandler(value={SQLIntegrityConstraintViolationException.class, DataIntegrityViolationException.class})
    public Json deleteUsingDataException(@NotNull Exception exception) {
        log.error(exception.getMessage());
        if (Configs.getServiceConfig().isDebug()) {
            log.error(ServiceError.FORBIDDEN_DELETE_USED.getMessage(), (Throwable)exception);
        }
        return Json.error(ServiceError.FORBIDDEN_DELETE_USED);
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public Json notFoundHandle(@NotNull NoHandlerFoundException exception, HttpServletResponse response) {
        String packageName;
        boolean result;
        String[] arr;
        log.error(exception.getMessage());
        if (Configs.getServiceConfig().isEnableDocument() && (arr = exception.getRequestURL().split("/")).length > 1 && !(result = ApiDocument.writeEntityDocument(packageName = arr[arr.length - 1], response))) {
            response.reset();
            return Json.error(ServiceError.API_SERVICE_UNSUPPORTED);
        }
        return Json.error(ServiceError.API_SERVICE_UNSUPPORTED);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public Json dataExceptionHandle(@NotNull HttpMessageNotReadableException exception) {
        log.error(exception.getMessage());
        return Json.error(ServiceError.REQUEST_CONTENT_TYPE_UNSUPPORTED, "\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e,\u8bf7\u68c0\u67e5\u662f\u5426\u63a5\u53e3\u652f\u6301\u7684JSON");
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public Json methodExceptionHandle(@NotNull HttpRequestMethodNotSupportedException exception) {
        log.error(exception.getMessage());
        String supportedMethod = String.join((CharSequence)"/", Objects.requireNonNull(exception.getSupportedMethods()));
        return Json.error(ServiceError.REQUEST_METHOD_UNSUPPORTED, String.format("%s \u4e0d\u88ab\u652f\u6301\uff0c\u8bf7\u4f7f\u7528 %s \u65b9\u6cd5\u8bf7\u6c42", exception.getMethod(), supportedMethod));
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    public Json httpMediaTypeNotSupportedExceptionHandle(@NotNull HttpMediaTypeNotSupportedException exception) {
        log.error(exception.getMessage());
        if (Configs.getServiceConfig().isDebug()) {
            log.error(ServiceError.REQUEST_CONTENT_TYPE_UNSUPPORTED.getMessage(), (Throwable)exception);
        }
        return Json.error(ServiceError.REQUEST_CONTENT_TYPE_UNSUPPORTED, String.format("%s \u4e0d\u88ab\u652f\u6301\uff0c\u8bf7\u4f7f\u7528JSON\u8bf7\u6c42", Objects.requireNonNull(exception.getContentType()).getType()));
    }

    @ExceptionHandler(value={CannotCreateTransactionException.class})
    public Json databaseExceptionHandle(@NotNull CannotCreateTransactionException exception) {
        log.error(exception.getMessage());
        if (Configs.getServiceConfig().isDebug()) {
            log.error(ServiceError.DATABASE_ERROR.getMessage(), (Throwable)exception);
        }
        return Json.error(ServiceError.DATABASE_ERROR);
    }

    @ExceptionHandler(value={RedisConnectionFailureException.class})
    public Json redisExceptionHandle(@NotNull RedisConnectionFailureException exception) {
        log.error(exception.getMessage());
        if (Configs.getServiceConfig().isDebug()) {
            log.error(ServiceError.REDIS_ERROR.getMessage(), (Throwable)exception);
        }
        return Json.error(ServiceError.REDIS_ERROR);
    }

    @ExceptionHandler(value={ServiceException.class})
    public Json systemExceptionHandle(@NotNull ServiceException exception) {
        log.error(exception.getMessage());
        if (Configs.getServiceConfig().isDebug()) {
            log.error(ServiceError.SERVICE_ERROR.getMessage(), (Throwable)exception);
        }
        return Json.error(exception).setData(exception.getData());
    }

    @ExceptionHandler(value={PropertyReferenceException.class})
    public Json propertyReferenceExceptionHandle(@NotNull PropertyReferenceException exception) {
        log.error(exception.getMessage());
        if (Configs.getServiceConfig().isDebug()) {
            log.error(ServiceError.DATABASE_UNKNOWN_FIELD.getMessage(), (Throwable)exception);
        }
        return Json.error(ServiceError.DATABASE_UNKNOWN_FIELD, String.format("\u6570\u636e\u5e93\u7f3a\u5c11\u5b57\u6bb5%s", exception.getPropertyName()));
    }

    @ExceptionHandler(value={InvalidDataAccessResourceUsageException.class})
    public Json invalidDataAccessResourceUsageExceptionHandle(@NotNull InvalidDataAccessResourceUsageException exception) {
        log.error(exception.getMessage());
        if (Configs.getServiceConfig().isDebug()) {
            log.error(ServiceError.DATABASE_TABLE_OR_FIELD_ERROR.getMessage(), (Throwable)exception);
        }
        return Json.error(ServiceError.DATABASE_TABLE_OR_FIELD_ERROR);
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    public Json maxUploadSizeExceededExceptionHandle(@NotNull MaxUploadSizeExceededException exception) {
        log.error(exception.getMessage());
        if (Configs.getServiceConfig().isDebug()) {
            log.error(ServiceError.FORBIDDEN_UPLOAD_MAX_SIZE.getMessage(), (Throwable)exception);
        }
        return Json.error(ServiceError.FORBIDDEN_UPLOAD_MAX_SIZE);
    }

    @ExceptionHandler(value={Exception.class, RuntimeException.class})
    public Object otherExceptionHandle(@NotNull Exception exception) {
        log.error(exception.getMessage());
        if (Configs.getServiceConfig().isDebug()) {
            log.error(ServiceError.SERVICE_ERROR.getMessage(), (Throwable)exception);
        }
        return Json.error(ServiceError.SERVICE_ERROR);
    }
}

