/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.datasource;

import cn.hamm.airpower.config.Configs;
import cn.hamm.airpower.datasource.DataSource;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceBuilder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;
import org.springframework.stereotype.Service;

@Service
public class DataSourceResolver
extends AbstractRoutingDataSource {
    private static final Logger log = LoggerFactory.getLogger(DataSourceResolver.class);
    public static final Map<Object, Object> DATA_SOURCE_LIST = new HashMap<Object, Object>();
    private static final String DATASOURCE_SCHEME = "jdbc:mysql://";
    private static final String DRIVER_NAME = "com.mysql.jdbc.Driver";
    private static final String DATASOURCE_CONFIG = "?allowPublicKeyRetrieval=true&serverTimezone=UTC&useUnicode=true&characterEncoding=utf8&useSSL=false";
    private static final ThreadLocal<String> THREAD_LOCAL = new ThreadLocal();

    public DataSourceResolver() {
        super.setTargetDataSources(DATA_SOURCE_LIST);
    }

    public static String getDataSourceParam() {
        return THREAD_LOCAL.get();
    }

    public static void setDataSourceParam(String param) {
        THREAD_LOCAL.set(param);
    }

    public static void clearDataSourceParam() {
        THREAD_LOCAL.remove();
    }

    @NotNull
    private static String getDataSourceUrl(DataSource dataSource) {
        return DataSourceResolver.getServerUrl(dataSource) + "/" + Configs.getServiceConfig().getDatabasePrefix() + dataSource.getDatabase() + DATASOURCE_CONFIG;
    }

    @NotNull
    private static String getServerUrl(@NotNull DataSource dataSource) {
        return DATASOURCE_SCHEME + dataSource.getHost() + ":" + dataSource.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDatabase(DataSource dataSource) {
        Statement statement = null;
        Connection connection = null;
        try {
            Class.forName(DRIVER_NAME);
            connection = DriverManager.getConnection(DataSourceResolver.getServerUrl(dataSource), dataSource.getUser(), dataSource.getPassword());
            statement = connection.createStatement();
            statement.execute("CREATE DATABASE IF NOT EXISTS " + Configs.getServiceConfig().getDatabasePrefix() + dataSource.getDatabase() + " DEFAULT CHARACTER SET utf8mb4 DEFAULT COLLATE utf8mb4_general_ci");
        }
        catch (Exception exception) {
            log.error("SQL\u8bed\u53e5\u6267\u884c\u5931\u8d25", (Throwable)exception);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                log.error("\u6570\u636e\u5e93\u8fde\u63a5\u5173\u95ed\u5931\u8d25", (Throwable)exception);
            }
        }
    }

    public void createDataSource(DataSource dataSourceInfo) {
        DruidDataSource dataSource = DruidDataSourceBuilder.create().build();
        dataSource.setDriverClassName(DRIVER_NAME);
        dataSource.setUrl(DataSourceResolver.getDataSourceUrl(dataSourceInfo));
        dataSource.setUsername(dataSourceInfo.getUser());
        dataSource.setPassword(dataSourceInfo.getPassword());
        DATA_SOURCE_LIST.put(Configs.getServiceConfig().getDatabasePrefix() + dataSourceInfo.getDatabase(), dataSource);
        super.afterPropertiesSet();
    }

    protected Object determineCurrentLookupKey() {
        return DataSourceResolver.getDataSourceParam();
    }
}

