/*
 * Decompiled with CFR 0.152.
 */
package cn.hamm.airpower.validate.phone;

import cn.hamm.airpower.util.AirUtil;
import cn.hamm.airpower.validate.phone.Phone;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import org.jetbrains.annotations.NotNull;
import org.springframework.util.StringUtils;

public class PhoneAnnotationValidator
implements ConstraintValidator<Phone, String> {
    private boolean tel = true;
    private boolean mobile = true;

    public final boolean isValid(String value, ConstraintValidatorContext context) {
        if (!StringUtils.hasLength((String)value)) {
            return true;
        }
        if (!this.mobile && !this.tel) {
            return true;
        }
        if (!this.mobile) {
            return AirUtil.getValidateUtil().isTelPhone(value);
        }
        if (!this.tel) {
            return AirUtil.getValidateUtil().isMobilePhone(value);
        }
        return AirUtil.getValidateUtil().isMobilePhone(value) || AirUtil.getValidateUtil().isTelPhone(value);
    }

    public final void initialize(@NotNull Phone constraintAnnotation) {
        this.mobile = constraintAnnotation.mobile();
        this.tel = constraintAnnotation.tel();
    }
}

